/*
 * Decompiled with CFR 0.152.
 */
package jdave.runner;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import jdave.runner.IAnnotatedSpecHandler;
import jdave.runner.IFileHandler;
import jdave.runner.Scanner;
import net.sf.cglib.asm.Attribute;
import net.sf.cglib.asm.ClassAdapter;
import net.sf.cglib.asm.ClassReader;
import net.sf.cglib.asm.ClassVisitor;
import net.sf.cglib.asm.ClassWriter;
import net.sf.cglib.asm.attrs.Annotation;
import net.sf.cglib.asm.attrs.Attributes;
import net.sf.cglib.asm.attrs.RuntimeVisibleAnnotations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnnotatedSpecScanner {
    private Scanner scanner;

    public AnnotatedSpecScanner(String path) {
        this.scanner = new Scanner(path);
    }

    public void forEach(final IAnnotatedSpecHandler annotatedSpecHandler) {
        this.scanner.forEach("class", new IFileHandler(){

            public void handle(File file) {
                try {
                    AnnotationReader reader = new AnnotationReader(new BufferedInputStream(new FileInputStream(file)));
                    if (reader.getGroups() != null) {
                        annotatedSpecHandler.handle(reader.getClassname(), reader.getGroups());
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public abstract boolean isInDefaultGroup(String var1, Collection<Annotation> var2);

    class AnnotationReader
    extends ClassAdapter {
        private String classname;
        private String[] groups;

        public AnnotationReader(InputStream classAsStream) throws IOException {
            super((ClassVisitor)new ClassWriter(false));
            ClassReader reader = new ClassReader(classAsStream);
            reader.accept((ClassVisitor)this, Attributes.getDefaultAttributes(), true);
            classAsStream.close();
        }

        public String[] getGroups() {
            return this.groups;
        }

        public String getClassname() {
            return this.classname;
        }

        public void visit(int access, int arg1, String name, String superName, String[] interfaces, String sourceFile) {
            this.classname = name.replace('/', '.');
        }

        public void visitAttribute(Attribute attr) {
            if (attr instanceof RuntimeVisibleAnnotations) {
                this.visitRuntimeVisibleAnnotations((RuntimeVisibleAnnotations)attr);
            }
        }

        private void visitRuntimeVisibleAnnotations(RuntimeVisibleAnnotations annotations) {
            this.checkIfGroupAnnotationPresent(annotations);
            if (this.groups == null) {
                this.checkIfInDefaultGroup(annotations);
            }
        }

        private void checkIfGroupAnnotationPresent(RuntimeVisibleAnnotations annotations) {
            for (Object object : annotations.annotations) {
                Annotation annotation = (Annotation)object;
                if (!annotation.type.equals("Ljdave/Group;")) continue;
                this.visitGroupAnnotation(annotation);
            }
        }

        private void checkIfInDefaultGroup(RuntimeVisibleAnnotations annotations) {
            if (AnnotatedSpecScanner.this.isInDefaultGroup(this.classname, annotations.annotations)) {
                this.groups = new String[]{"__default_group"};
            }
        }

        private void visitGroupAnnotation(Annotation annotation) {
            List elementValues = annotation.elementValues;
            for (Object elementValue : elementValues) {
                Object[] values;
                for (Object param : values = (Object[])elementValue) {
                    if (!param.getClass().isArray()) continue;
                    Object[] params = (Object[])param;
                    this.groups = new String[params.length];
                    for (int j = 0; j < params.length; ++j) {
                        this.groups[j] = (String)params[j];
                    }
                }
            }
        }
    }
}

