/*
 * Decompiled with CFR 0.152.
 */
package jdave;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.HashMap;
import java.util.Map;
import jdave.ExpectationFailedException;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;
import org.jmock.api.Imposteriser;
import org.jmock.api.Invocation;
import org.jmock.api.Invokable;
import org.jmock.lib.legacy.ClassImposteriser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Each<T> {
    protected T item;
    private Invocation invocation;
    private Matcher<?> matcher;
    private Matcher<?>[] matchers;
    private static final Map<Class<?>, Object> BOXED_VALUES = new HashMap<Class<?>, Object>(){
        {
            this.put(Boolean.TYPE, Boolean.TRUE);
            this.put(Byte.TYPE, (byte)0);
            this.put(Character.TYPE, Character.valueOf('a'));
            this.put(Short.TYPE, (short)0);
            this.put(Integer.TYPE, 0);
            this.put(Long.TYPE, 0L);
            this.put(Float.TYPE, Float.valueOf(0.0f));
            this.put(Double.TYPE, 0.0);
        }
    };

    public Each() {
        ParameterizedType superclass = (ParameterizedType)this.getClass().getGenericSuperclass();
        Class type = (Class)superclass.getActualTypeArguments()[0];
        Imposteriser imposteriser = ClassImposteriser.INSTANCE;
        this.item = imposteriser.imposterise(new Invokable(){

            public Object invoke(Invocation invocation) throws Throwable {
                Each.this.invocation = invocation;
                return Each.this.nullOrBoxed(invocation);
            }
        }, type, new Class[0]);
    }

    private Object nullOrBoxed(Invocation invocation) {
        return BOXED_VALUES.get(invocation.getInvokedMethod().getReturnType());
    }

    protected void matches(Object itemToMatch, Matcher<?> matcher) {
        this.matcher = matcher;
    }

    protected void matches(Object itemToMatch, Matcher<?> ... matchers) {
        this.matchers = matchers;
    }

    void match(T realItem, int index) {
        Object itemToMatch = this.itemToMatch(realItem);
        Matcher<?> nextMatcher = this.nextMatcher(index);
        if (!nextMatcher.matches(itemToMatch)) {
            throw new ExpectationFailedException(itemToMatch + " does not satisfy '" + StringDescription.toString(nextMatcher) + "'");
        }
    }

    private Object itemToMatch(T realItem) {
        if (this.invocation == null) {
            return realItem;
        }
        return this.nextItemToMatch(realItem, this.invocation.getInvokedMethod());
    }

    private Object nextItemToMatch(T realItem, Method invokedMethod) {
        try {
            Method realMethod = realItem.getClass().getMethod(invokedMethod.getName(), invokedMethod.getParameterTypes());
            return realMethod.invoke(realItem, this.invocation.getParametersAsArray());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Matcher<?> nextMatcher(int index) {
        if (this.matcher != null) {
            return this.matcher;
        }
        if (index == this.matchers.length) {
            throw new ExpectationFailedException("Not enough matchers, current index = " + index);
        }
        return this.matchers[index];
    }

    public void areAllMatchersUsed(int index) {
        if (this.matchers != null && index < this.matchers.length) {
            throw new ExpectationFailedException("Not enough elements, expected " + this.matchers.length + " elements.");
        }
    }
}

