/*
 * Decompiled with CFR 0.152.
 */
package com.objogate.math;

import com.objogate.math.Vector2D;

public class CubicBezierCurve2D {
    private double _p1_x;
    private double _p1_y;
    private double _ctl1_x;
    private double _ctl1_y;
    private double _ctl2_x;
    private double _ctl2_y;
    private double _p2_x;
    private double _p2_y;

    public CubicBezierCurve2D(Vector2D p1, Vector2D ctl1, Vector2D ctl2, Vector2D p2) {
        this(p1.x(), p1.y(), ctl1.x(), ctl1.y(), ctl2.x(), ctl2.y(), p2.x(), p2.y());
    }

    public CubicBezierCurve2D(double p1_x, double p1_y, double ctl1_x, double ctl1_y, double ctl2_x, double ctl2_y, double p2_x, double p2_y) {
        this._p1_x = p1_x;
        this._p1_y = p1_y;
        this._ctl1_x = ctl1_x;
        this._ctl1_y = ctl1_y;
        this._ctl2_x = ctl2_x;
        this._ctl2_y = ctl2_y;
        this._p2_x = p2_x;
        this._p2_y = p2_y;
    }

    public CubicBezierCurve2D(double[] curve) {
        this(curve[0], curve[1], curve[2], curve[3], curve[4], curve[5], curve[6], curve[7]);
    }

    public Vector2D p1() {
        return new Vector2D(this._p1_x, this._p1_y);
    }

    public Vector2D ctl1() {
        return new Vector2D(this._ctl1_x, this._ctl1_y);
    }

    public Vector2D ctl2() {
        return new Vector2D(this._ctl2_x, this._ctl2_y);
    }

    public Vector2D p2() {
        return new Vector2D(this._p2_x, this._p2_y);
    }

    public Vector2D p(double u) {
        return new Vector2D(this.x(u), this.y(u));
    }

    public double x(double u) {
        return CubicBezierCurve2D.interpolate(this._p1_x, this._ctl1_x, this._ctl2_x, this._p2_x, u);
    }

    public double y(double u) {
        return CubicBezierCurve2D.interpolate(this._p1_y, this._ctl1_y, this._ctl2_y, this._p2_y, u);
    }

    private static double interpolate(double p1, double p2, double p3, double p4, double u) {
        double inv_u = 1.0 - u;
        return inv_u * inv_u * inv_u * p1 + 3.0 * inv_u * inv_u * u * p2 + 3.0 * inv_u * u * u * p3 + u * u * u * p4;
    }
}

