/*
 * Decompiled with CFR 0.152.
 */
package com.objogate.math;

import java.awt.Point;

public final class Vector2D {
    private final double x;
    private final double y;

    public Vector2D() {
        this.x = 0.0;
        this.y = 0.0;
    }

    public Vector2D(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Vector2D(Point p) {
        this.x = p.x;
        this.y = p.y;
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.x);
        return (int)(bits ^= Double.doubleToLongBits(this.y) * 31L) ^ (int)(bits >> 32);
    }

    public boolean equals(Object o) {
        return o instanceof Vector2D && this.equals((Vector2D)o);
    }

    public boolean equals(Vector2D v) {
        return this.x == v.x && this.y == v.y;
    }

    public boolean equals(Vector2D v, double allowable_error) {
        return Math.abs(this.x - v.x) <= allowable_error && Math.abs(this.y - v.y) <= allowable_error;
    }

    public double magnitudeSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public double magnitude() {
        return Math.sqrt(this.magnitudeSquared());
    }

    public Vector2D normalise() {
        return this.div(this.magnitude());
    }

    public Vector2D add(Vector2D v) {
        return new Vector2D(this.x + v.x, this.y + v.y);
    }

    public Vector2D sub(Vector2D v) {
        return new Vector2D(this.x - v.x, this.y - v.y);
    }

    public Vector2D mul(double n) {
        return new Vector2D(this.x * n, this.y * n);
    }

    public Vector2D div(double n) {
        return new Vector2D(this.x / n, this.y / n);
    }

    public double dot(Vector2D v) {
        return this.x * v.x + this.y * v.y;
    }

    public Vector2D rotate(double cosTheta, double sinTheta) {
        return new Vector2D(this.x * cosTheta - this.y * sinTheta, this.x * sinTheta + this.y * cosTheta);
    }

    public Vector2D rotate(double radians) {
        return this.rotate(Math.cos(radians), Math.sin(radians));
    }

    public Vector2D translate(double dx, double dy) {
        return new Vector2D(this.x + dx, this.y + dy);
    }

    public Vector2D scale(double sx, double sy) {
        return new Vector2D(this.x * sx, this.y * sy);
    }

    public double distanceSquared(Vector2D p) {
        return this.sub(p).magnitudeSquared();
    }

    public double distance(Vector2D p) {
        return this.sub(p).magnitude();
    }

    public double cosAngle(Vector2D v) {
        return this.dot(v) / (this.magnitude() * v.magnitude());
    }

    public double angle(Vector2D v) {
        return Math.acos(this.cosAngle(v));
    }

    public boolean isPerpendicular(Vector2D v) {
        return this.cosAngle(v) == 0.0;
    }

    public String toString() {
        return "(" + this.x + "," + this.y + ")";
    }

    public Point floor() {
        return new Point((int)Math.floor(this.x), (int)Math.floor(this.y));
    }

    public Point ceil() {
        return new Point((int)Math.ceil(this.x), (int)Math.ceil(this.y));
    }

    public Point round() {
        return new Point((int)Math.round(this.x), (int)Math.round(this.y));
    }

    public static Vector2D polar(double angle, double length) {
        return new Vector2D(Math.cos(angle) * length, Math.sin(angle) * length);
    }
}

