/*
 * Decompiled with CFR 0.152.
 */
package com.objogate.wl;

import com.objogate.wl.Probe;
import com.objogate.wl.Prober;
import com.objogate.wl.SystemProperties;
import com.objogate.wl.internal.ProbeRunner;
import com.objogate.wl.internal.Timeout;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import org.hamcrest.Description;
import org.hamcrest.StringDescription;

public class AWTEventQueueProber
implements Prober,
SystemProperties {
    private long timeoutMillis;
    private long pollDelayMillis;

    public AWTEventQueueProber() {
        this(AWTEventQueueProber.defaultTimeout(), AWTEventQueueProber.defaultPollDelay());
    }

    public AWTEventQueueProber(long timeoutMillis, long pollDelayMillis) {
        this.timeoutMillis = timeoutMillis;
        this.pollDelayMillis = pollDelayMillis;
    }

    public long getTimeout() {
        return this.timeoutMillis;
    }

    public void setTimeout(long timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
    }

    public long getPollDelay() {
        return this.pollDelayMillis;
    }

    public void setPollDelay(long pollDelayMillis) {
        this.pollDelayMillis = pollDelayMillis;
    }

    public boolean poll(Probe probe) {
        ProbeRunner probeRunner = new ProbeRunner(probe);
        Timeout timeout = new Timeout(this.timeoutMillis);
        try {
            while (true) {
                EventQueue.invokeAndWait(probeRunner);
                if (probe.isSatisfied()) {
                    return true;
                }
                if (timeout.hasTimedOut()) {
                    return false;
                }
                Thread.sleep(this.pollDelayMillis);
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("unexpected interrupt", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("predicate failed", e.getCause());
        }
    }

    public void check(Probe probe) {
        if (!this.poll(probe)) {
            StringDescription description = new StringDescription();
            description.appendText("\nTried to look for...\n    ");
            probe.describeTo((Description)description);
            description.appendText("\nbut...\n    ");
            probe.describeFailureTo((Description)description);
            throw new AssertionError((Object)description.toString());
        }
    }

    private static long defaultPollDelay() {
        return AWTEventQueueProber.parseIntSystemProperty("com.objogate.wl.poll-delay", 100L);
    }

    private static long defaultTimeout() {
        return AWTEventQueueProber.parseIntSystemProperty("com.objogate.wl.timeout", 5000L);
    }

    private static long parseIntSystemProperty(String propertyName, long defaultValue) {
        return Long.parseLong(System.getProperty(propertyName, String.valueOf(defaultValue)));
    }
}

