/*
 * Decompiled with CFR 0.152.
 */
package com.objogate.wl.driver;

import com.objogate.wl.ComponentSelector;
import com.objogate.wl.Prober;
import com.objogate.wl.Query;
import com.objogate.wl.driver.ComponentDriver;
import com.objogate.wl.gesture.GesturePerformer;
import com.objogate.wl.internal.PropertyQuery;
import com.objogate.wl.internal.query.MnemonicQuery;
import com.objogate.wl.internal.query.TextQuery;
import java.awt.Component;
import javax.swing.AbstractButton;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractButtonDriver<T extends AbstractButton>
extends ComponentDriver<T>
implements TextQuery,
MnemonicQuery {
    public AbstractButtonDriver(GesturePerformer gesturePerformer, T component) {
        super(gesturePerformer, component);
    }

    public AbstractButtonDriver(GesturePerformer gesturePerformer, T component, Prober prober) {
        super(gesturePerformer, component, prober);
    }

    public AbstractButtonDriver(GesturePerformer gesturePerformer, ComponentSelector<T> componentSelector) {
        super(gesturePerformer, componentSelector);
    }

    public AbstractButtonDriver(GesturePerformer gesturePerformer, ComponentSelector<T> componentSelector, Prober prober) {
        super(gesturePerformer, componentSelector, prober);
    }

    public AbstractButtonDriver(ComponentDriver<? extends Component> parentOrOwner, ComponentSelector<T> componentSelector) {
        super(parentOrOwner, componentSelector);
    }

    public AbstractButtonDriver(ComponentDriver<? extends Component> parentOrOwner, Class<T> componentType, Matcher<? super T> ... matchers) {
        super(parentOrOwner, componentType, matchers);
    }

    public void click() {
        this.leftClickOnComponent();
    }

    @Override
    public void text(Matcher<String> textMatcher) {
        this.hasText(textMatcher);
    }

    @Override
    public void hasText(Matcher<String> matcher) {
        this.has(this.text(), matcher);
    }

    private Query<T, String> text() {
        return new Query<T, String>(){

            @Override
            public String query(T button) {
                return ((AbstractButton)button).getText();
            }

            public void describeTo(Description description) {
                description.appendText("text");
            }
        };
    }

    @Override
    public void mnemonic(Matcher<Character> matcher) {
        this.has(AbstractButtonDriver.mnemonic(), matcher);
    }

    private static <B extends AbstractButton> Query<B, Character> mnemonic() {
        return new PropertyQuery<B, Character>("mnemonic"){

            @Override
            public Character query(B button) {
                return Character.valueOf((char)((AbstractButton)button).getMnemonic());
            }
        };
    }

    public void isChecked() {
        this.is(this.selected());
    }

    public void isNotChecked() {
        this.is(Matchers.not(this.selected()));
    }

    private TypeSafeMatcher<AbstractButton> selected() {
        return new TypeSafeMatcher<AbstractButton>(){

            public boolean matchesSafely(AbstractButton item) {
                return item.isSelected();
            }

            public void describeTo(Description description) {
                description.appendText("is selected");
            }
        };
    }
}

