/*
 * Decompiled with CFR 0.152.
 */
package com.objogate.wl.driver;

import com.objogate.exception.Defect;
import com.objogate.wl.driver.AbstractButtonDriver;
import com.objogate.wl.driver.ComponentDriver;
import com.objogate.wl.driver.JComboBoxDriver;
import com.objogate.wl.driver.JFileChooserDriver;
import com.objogate.wl.driver.JTableDriver;
import com.objogate.wl.driver.JTextFieldDriver;
import com.objogate.wl.driver.MetalFileChooserUIDriver;
import com.objogate.wl.gesture.Gestures;
import com.objogate.wl.matcher.ComponentMatchers;
import com.objogate.wl.matcher.JLabelTextMatcher;
import java.awt.Component;
import java.awt.Container;
import java.util.concurrent.TimeUnit;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;

class AquaFileChooserUIDriver
extends MetalFileChooserUIDriver {
    public AquaFileChooserUIDriver(JFileChooserDriver jFileChooserDriver) {
        super(jFileChooserDriver);
    }

    public void selectFile(String fileName) {
        JTableDriver fileEntry = new JTableDriver((ComponentDriver<? extends Component>)this.parentOrOwner, JTable.class, (Matcher<? super JTable>[])new Matcher[0]);
        fileEntry.selectCell((Matcher<? extends JComponent>)new JLabelTextMatcher((Matcher<String>)Matchers.equalTo((Object)fileName)));
        try {
            TimeUnit.MILLISECONDS.sleep(1000L);
            fileEntry.selectCell((Matcher<? extends JComponent>)new JLabelTextMatcher((Matcher<String>)Matchers.equalTo((Object)fileName)));
        }
        catch (InterruptedException e) {
            throw new Defect("Unable to select file", e);
        }
    }

    public void intoDir(String directoryName) {
        this.selectFile(directoryName);
        this.parentOrOwner.performGesture(Gestures.doubleClickMouse());
    }

    public void createNewFolder(String folderName) {
        new AbstractButtonDriver<JButton>(this.parentOrOwner, JButton.class, new Matcher[]{ComponentMatchers.withButtonText("New Folder")}).click();
        JTextFieldDriver textDriver = new JTextFieldDriver((ComponentDriver<? extends Component>)this.parentOrOwner, JTextField.class, (Matcher<? super JTextField>[])new Matcher[]{new TypeSafeMatcher<JTextField>(){

            public boolean matchesSafely(JTextField jTextField) {
                Container container = jTextField.getParent();
                Component component = container.getComponent(0);
                if (component instanceof JLabel) {
                    JLabel jLabel = (JLabel)component;
                    return jLabel.getText().equals("File:");
                }
                return false;
            }

            public void describeTo(Description description) {
                description.appendText("JTextField with JLabel sibling containing text 'File'");
            }
        }});
        textDriver.typeText(folderName);
        textDriver.typeText("\t");
        textDriver.typeText("\t");
        textDriver.typeText(" ");
    }

    public void upOneFolder() {
        JComboBoxDriver boxDriver = new JComboBoxDriver((ComponentDriver<? extends Component>)this.parentOrOwner, JComboBox.class, (Matcher<? super JComboBox>[])new Matcher[]{new MacComboBoxModelTypeMatcher(), new ComboBoxModelMinSizeMatcher(2)});
        boxDriver.selectItem(1);
    }

    public void documents() {
        throw new UnsupportedOperationException("There is no 'Documents' button in the Aqua L&F");
    }

    public void home() {
        throw new UnsupportedOperationException("There is no 'Home' button in the Aqua L&F");
    }

    public void desktop() {
        throw new UnsupportedOperationException("There is no 'Desktop' button in the Aqua L&F");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ComboBoxModelMinSizeMatcher
    extends TypeSafeMatcher<JComboBox> {
        private final int minSize;

        public ComboBoxModelMinSizeMatcher(int minSize) {
            this.minSize = minSize;
        }

        public boolean matchesSafely(JComboBox jComboBox) {
            ComboBoxModel comboBoxModel = jComboBox.getModel();
            return comboBoxModel.getSize() >= this.minSize;
        }

        public void describeTo(Description description) {
            description.appendText("JComboBox with model with at least on entry");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MacComboBoxModelTypeMatcher
    extends TypeSafeMatcher<JComboBox> {
        private static final String TYPE = "apple.laf.AquaFileChooserUI$DirectoryComboBoxModel";

        private MacComboBoxModelTypeMatcher() {
        }

        public boolean matchesSafely(JComboBox jComboBox) {
            ComboBoxModel comboBoxModel = jComboBox.getModel();
            return comboBoxModel.getClass().getName().equals(TYPE);
        }

        public void describeTo(Description description) {
            description.appendText("JComboBox with model of type apple.laf.AquaFileChooserUI$DirectoryComboBoxModel");
        }
    }
}

