/*
 * Decompiled with CFR 0.152.
 */
package com.objogate.wl.driver;

import com.objogate.wl.AWTEventQueueProber;
import com.objogate.wl.ComponentFinder;
import com.objogate.wl.ComponentManipulation;
import com.objogate.wl.ComponentSelector;
import com.objogate.wl.Gesture;
import com.objogate.wl.Probe;
import com.objogate.wl.Prober;
import com.objogate.wl.Query;
import com.objogate.wl.gesture.ComponentCenterTracker;
import com.objogate.wl.gesture.ComponentOffsetTracker;
import com.objogate.wl.gesture.GesturePerformer;
import com.objogate.wl.gesture.Gestures;
import com.objogate.wl.gesture.Tracker;
import com.objogate.wl.internal.PropertyQuery;
import com.objogate.wl.matcher.ComponentEnabledMatcher;
import com.objogate.wl.matcher.ComponentOpaqueMatcher;
import com.objogate.wl.matcher.DisplayableComponentMatcher;
import com.objogate.wl.matcher.ShowingOnScreenMatcher;
import com.objogate.wl.probe.ComponentAssertionProbe;
import com.objogate.wl.probe.ComponentFinders;
import com.objogate.wl.probe.ComponentIdentity;
import com.objogate.wl.probe.ComponentManipulatorProbe;
import com.objogate.wl.probe.ComponentPropertyAssertionProbe;
import com.objogate.wl.probe.RecursiveComponentFinder;
import com.objogate.wl.probe.SingleComponentFinder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import org.hamcrest.BaseMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ComponentDriver<T extends Component> {
    private final Prober prober;
    private final ComponentSelector<T> selector;
    protected final GesturePerformer gesturePerformer;

    public ComponentDriver(GesturePerformer gesturePerformer, T component) {
        this(gesturePerformer, (ComponentSelector<T>)new ComponentIdentity<T>(component));
    }

    public ComponentDriver(GesturePerformer gesturePerformer, T component, Prober prober) {
        this(gesturePerformer, new ComponentIdentity<T>(component), prober);
    }

    public ComponentDriver(GesturePerformer gesturePerformer, ComponentSelector<T> selector) {
        this(gesturePerformer, selector, (Prober)new AWTEventQueueProber());
    }

    public ComponentDriver(GesturePerformer gesturePerformer, ComponentSelector<T> selector, Prober prober) {
        this.selector = selector;
        this.prober = prober;
        this.gesturePerformer = gesturePerformer;
    }

    public ComponentDriver(ComponentDriver<? extends Component> parentOrOwner, ComponentSelector<T> selector) {
        this.selector = selector;
        this.prober = parentOrOwner.prober;
        this.gesturePerformer = parentOrOwner.gesturePerformer;
    }

    public ComponentDriver(ComponentDriver<? extends Component> parentOrOwner, Class<T> componentType, Matcher<? super T> ... matchers) {
        this(parentOrOwner, new SingleComponentFinder<T>(new RecursiveComponentFinder<T>(componentType, CoreMatchers.allOf(matchers), parentOrOwner.selector)));
    }

    public void check(Probe probe) {
        this.prober.check(probe);
    }

    public ComponentSelector<T> component() {
        return this.selector;
    }

    public <U extends Component> ComponentFinder<U> all(Class<U> type, Matcher<? super U> criteria) {
        return ComponentFinders.all(type, criteria, this.selector);
    }

    public <U extends Component> ComponentSelector<U> the(Class<U> type, Matcher<? super U> criteria) {
        return ComponentFinders.the(type, criteria, this.selector);
    }

    public void is(Matcher<? super T> criteria) {
        this.check(new ComponentAssertionProbe<T>(this.selector, criteria));
    }

    public <P> void has(Query<? super T, P> query, Matcher<? super P> criteria) {
        this.check(new ComponentPropertyAssertionProbe<T, P>(this.selector, query, criteria));
    }

    public void perform(String description, ComponentManipulation<? super T> manipulation) {
        this.check(new ComponentManipulatorProbe<T>(this.selector, manipulation));
    }

    public void performGesture(Gesture ... gestures) {
        this.gesturePerformer.perform(gestures);
    }

    protected Tracker offset(int offsetX, int offsetY) {
        return new ComponentOffsetTracker(this.prober, this.selector, offsetX, offsetY);
    }

    protected Tracker centerOfComponent() {
        return new ComponentCenterTracker(this.prober, this.selector);
    }

    protected Prober prober() {
        return this.prober;
    }

    public void leftClickOnComponent() {
        this.isShowingOnScreen();
        this.performGesture(Gestures.moveMouseTo(this.centerOfComponent()), Gestures.clickMouseButton(Gestures.BUTTON1));
    }

    protected void isShowingOnScreen() {
        this.is(ComponentDriver.showingOnScreen());
    }

    public void moveMouseToCenter() {
        this.performGesture(Gestures.moveMouseTo(this.centerOfComponent()));
    }

    public void moveMouseToOffset(int offsetX, int offsetY) {
        this.performGesture(Gestures.moveMouseTo(this.offset(offsetX, offsetY)));
    }

    protected Rectangle screenBounds() {
        this.isShowingOnScreen();
        ComponentLayoutManipulation layout = new ComponentLayoutManipulation();
        this.perform("ensure component is layed out", layout);
        ComponentBoundsManipulation manipulation = new ComponentBoundsManipulation();
        this.perform("bounds of component on screen", manipulation);
        return manipulation.getBounds();
    }

    protected void cut() {
        this.performGesture(Gestures.cut());
    }

    protected void copy() {
        this.performGesture(Gestures.copy());
    }

    protected void paste() {
        this.performGesture(Gestures.paste());
    }

    protected void selectAll() {
        this.performGesture(Gestures.selectAll());
    }

    public void hasForegroundColor(Color color) {
        this.hasForegroundColor((Matcher<Color>)Matchers.equalTo((Object)color));
    }

    public void hasForegroundColor(Matcher<Color> color) {
        this.has(ComponentDriver.foregroundColor(), color);
    }

    public void hasBackgroundColor(Color color) {
        this.hasBackgroundColor((Matcher<Color>)Matchers.equalTo((Object)color));
    }

    public void hasBackgroundColor(Matcher<Color> color) {
        this.has(ComponentDriver.backgroundColor(), color);
        this.is(ComponentDriver.opaque());
    }

    public static <T extends Component, P> Matcher<T> with(Query<? super T, P> propertyQuery, Matcher<? super P> valueMatcher) {
        return new QueryResultMatcher<T, P>(propertyQuery, valueMatcher);
    }

    public static Query<Component, String> name() {
        return new PropertyQuery<Component, String>("name"){

            @Override
            public String query(Component component) {
                return component.getName();
            }
        };
    }

    public static Query<Component, Color> backgroundColor() {
        return new PropertyQuery<Component, Color>("background color"){

            @Override
            public Color query(Component component) {
                return component.getBackground();
            }
        };
    }

    public static Matcher<Component> named(String nameValue) {
        return ComponentDriver.with(ComponentDriver.name(), Matchers.equalTo((Object)nameValue));
    }

    public static Matcher<Component> showingOnScreen() {
        return new ShowingOnScreenMatcher();
    }

    public static Matcher<Component> displayable() {
        return new DisplayableComponentMatcher();
    }

    public static Matcher<Component> opaque() {
        return new ComponentOpaqueMatcher();
    }

    public static Matcher<Component> enabled() {
        return new ComponentEnabledMatcher();
    }

    public static Query<Component, Color> foregroundColor() {
        return new PropertyQuery<Component, Color>("foreground color"){

            @Override
            public Color query(Component component) {
                return component.getForeground();
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ComponentLayoutManipulation<T extends Component>
    implements ComponentManipulation<T> {
        private ComponentLayoutManipulation() {
        }

        @Override
        public void manipulate(T component) {
            ((Component)component).getParent().doLayout();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ComponentBoundsManipulation<T extends Component>
    implements ComponentManipulation<T> {
        Rectangle bounds;

        private ComponentBoundsManipulation() {
        }

        @Override
        public void manipulate(T component) {
            this.bounds = new Rectangle(((Component)component).getLocationOnScreen(), ((Component)component).getSize());
        }

        public Rectangle getBounds() {
            return this.bounds;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class QueryResultMatcher<C, P>
    extends BaseMatcher<C> {
        private final Query<? super C, P> query;
        private final Matcher<? super P> resultMatcher;

        public QueryResultMatcher(Query<? super C, P> query, Matcher<? super P> resultMatcher) {
            this.query = query;
            this.resultMatcher = resultMatcher;
        }

        public boolean matches(Object item) {
            return item != null && this.resultMatcher.matches(this.query.query(item));
        }

        public void describeTo(Description description) {
            description.appendText("with ").appendDescriptionOf(this.query).appendText(" ").appendDescriptionOf(this.resultMatcher);
        }
    }
}

