/*
 * Decompiled with CFR 0.152.
 */
package com.objogate.wl.driver;

import com.objogate.wl.ComponentManipulation;
import com.objogate.wl.driver.AbstractButtonDriver;
import com.objogate.wl.driver.ComponentDriver;
import com.objogate.wl.driver.FileChooserUIDriver;
import com.objogate.wl.driver.JButtonDriver;
import com.objogate.wl.driver.JFileChooserDriver;
import com.objogate.wl.driver.JFrameDriver;
import com.objogate.wl.driver.JLabelDriver;
import com.objogate.wl.driver.JListDriver;
import com.objogate.wl.driver.JOptionPaneDriver;
import com.objogate.wl.driver.JTextComponentDriver;
import com.objogate.wl.driver.JTextFieldDriver;
import com.objogate.wl.gesture.Gestures;
import com.objogate.wl.matcher.ComponentMatchers;
import com.objogate.wl.matcher.JLabelTextMatcher;
import java.awt.Component;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GTKFileChooserUIDriver
implements FileChooserUIDriver {
    private final JFileChooserDriver parentOrOwner;

    public GTKFileChooserUIDriver(JFileChooserDriver jFileChooserDriver) {
        this.parentOrOwner = jFileChooserDriver;
    }

    @Override
    public void selectFile(String fileName) {
        JLabelDriver fileEntry = new JLabelDriver((ComponentDriver<? extends Component>)this.parentOrOwner, this.parentOrOwner.the(JLabel.class, ComponentMatchers.withLabelText((Matcher<String>)Matchers.equalTo((Object)fileName))));
        fileEntry.leftClickOnComponent();
    }

    @Override
    public void intoDir(String directoryName) {
        this.selectFile(directoryName);
        this.parentOrOwner.performGesture(Gestures.doubleClickMouse());
    }

    @Override
    public void createNewFolder(String folderName) {
        AbstractButtonDriver<Component> newFolderButton = new AbstractButtonDriver<Component>(this.parentOrOwner, this.parentOrOwner.the(JButton.class, ComponentDriver.named("GTKFileChooser.newFolderButton")));
        newFolderButton.click();
        JFrameDriver jframe = new JFrameDriver(this.parentOrOwner.gesturePerformer, JFileChooserDriver.rootFrameFor(this.parentOrOwner.component().component()));
        JOptionPaneDriver folderEntry = new JOptionPaneDriver((ComponentDriver<? extends Component>)jframe, JOptionPane.class, (Matcher<? super JOptionPane>[])new Matcher[0]);
        folderEntry.typeText(folderName);
        folderEntry.clickOK();
    }

    @Override
    public void upOneFolder() {
        JListDriver directoryList = new JListDriver((ComponentDriver<? extends Component>)this.parentOrOwner, JList.class, (Matcher<? super JList>[])new Matcher[]{ComponentDriver.named("GTKFileChooser.directoryList")});
        CurrentDirectoryManipulator directoryManipulator = new CurrentDirectoryManipulator();
        this.parentOrOwner.perform("get current directory", directoryManipulator);
        directoryList.selectItem((Matcher<? extends Component>)new JLabelTextMatcher((Matcher<String>)Matchers.equalTo((Object)"..")));
    }

    @Override
    public void desktop() {
        throw new UnsupportedOperationException("There is no 'Desktop' button in the GTK L&F");
    }

    @Override
    public void documents() {
        throw new UnsupportedOperationException("There is no 'My Documents' button in the GTK L&F");
    }

    @Override
    public void home() {
        this.textBox().selectAll();
        this.textBox().typeText(System.getProperty("user.home"));
        this.approve();
    }

    @Override
    public void cancel() {
        new JButtonDriver((ComponentDriver<? extends Component>)this.parentOrOwner, JButton.class, (Matcher<? super JButton>[])new Matcher[]{ComponentDriver.named("SynthFileChooser.cancelButton")}).click();
    }

    @Override
    public void approve() {
        new JButtonDriver((ComponentDriver<? extends Component>)this.parentOrOwner, JButton.class, (Matcher<? super JButton>[])new Matcher[]{ComponentDriver.named("SynthFileChooser.approveButton")}).click();
    }

    @Override
    public JTextComponentDriver<? extends JTextComponent> textBox() {
        return new JTextFieldDriver((ComponentDriver<? extends Component>)this.parentOrOwner, JTextField.class, (Matcher<? super JTextField>[])new Matcher[]{ComponentDriver.named("GTKFileChooser.fileNameTextField")});
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CurrentDirectoryManipulator
    implements ComponentManipulation<JFileChooser> {
        File currentDirectory;

        private CurrentDirectoryManipulator() {
        }

        @Override
        public void manipulate(JFileChooser component) {
            this.currentDirectory = component.getCurrentDirectory();
        }

        public File getCurrentDirectory() {
            return this.currentDirectory;
        }
    }
}

