/*
 * Decompiled with CFR 0.152.
 */
package com.objogate.wl.driver;

import com.objogate.wl.ComponentFinder;
import com.objogate.wl.ComponentManipulation;
import com.objogate.wl.ComponentSelector;
import com.objogate.wl.Prober;
import com.objogate.wl.Query;
import com.objogate.wl.driver.ComponentDriver;
import com.objogate.wl.driver.JListDriver;
import com.objogate.wl.driver.ListDriver;
import com.objogate.wl.gesture.GesturePerformer;
import com.objogate.wl.probe.RecursiveComponentFinder;
import com.objogate.wl.probe.SingleComponentFinder;
import com.objogate.wl.probe.TopLevelWindowFinder;
import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.plaf.basic.ComboPopup;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JComboBoxDriver
extends ComponentDriver<JComboBox>
implements ListDriver {
    public JComboBoxDriver(GesturePerformer gesturePerformer, JComboBox component) {
        super(gesturePerformer, component);
    }

    public JComboBoxDriver(GesturePerformer gesturePerformer, JComboBox component, Prober prober) {
        super(gesturePerformer, component, prober);
    }

    public JComboBoxDriver(GesturePerformer gesturePerformer, ComponentSelector<JComboBox> componentSelector) {
        super(gesturePerformer, componentSelector);
    }

    public JComboBoxDriver(GesturePerformer gesturePerformer, ComponentSelector<JComboBox> componentSelector, Prober prober) {
        super(gesturePerformer, componentSelector, prober);
    }

    public JComboBoxDriver(ComponentDriver<? extends Component> parentOrOwner, ComponentSelector<JComboBox> componentSelector) {
        super(parentOrOwner, componentSelector);
    }

    public JComboBoxDriver(ComponentDriver<? extends Component> parentOrOwner, Class<JComboBox> componentType, Matcher<? super JComboBox> ... matchers) {
        super(parentOrOwner, componentType, matchers);
    }

    @Override
    public void selectItem(int index) {
        this.clickToOpenPopup();
        ComboPopupComponentDriver comboPopupDriver = new ComboPopupComponentDriver(this.gesturePerformer);
        comboPopupDriver.selectItem(index);
    }

    @Override
    public void selectItem(Matcher<? extends Component> item) {
        this.clickToOpenPopup();
        ComboPopupComponentDriver comboPopupDriver = new ComboPopupComponentDriver(this.gesturePerformer);
        comboPopupDriver.selectItem(item);
    }

    private void clickToOpenPopup() {
        this.leftClickOnComponent();
    }

    @Override
    public void hasSelectedIndex(int index) {
        this.has(new Query<JComboBox, Integer>(){

            @Override
            public Integer query(JComboBox component) {
                return component.getSelectedIndex();
            }

            public void describeTo(Description description) {
                description.appendText("selected index");
            }
        }, Matchers.equalTo((Object)index));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ComboPopupComponentDriver
    extends ComponentDriver<JComponent> {
        public ComboPopupComponentDriver(GesturePerformer gesturePerformer) {
            super(gesturePerformer, new SingleComponentFinder<JComponent>(new RecursiveComponentFinder<JComponent>(JComponent.class, (Matcher<JComponent>)ComboPopupComponentDriver.thatImplementsComboPopup(), (ComponentFinder<Component>)((ComponentFinder<? extends Component>)new TopLevelWindowFinder()))));
        }

        private static TypeSafeMatcher<JComponent> thatImplementsComboPopup() {
            return new TypeSafeMatcher<JComponent>(){

                public boolean matchesSafely(JComponent component) {
                    return component instanceof ComboPopup;
                }

                public void describeTo(Description description) {
                    description.appendText("a component that implements ComboPopup");
                }
            };
        }

        public void selectItem(int index) {
            JListFinderManipulation listFinderManipulation = new JListFinderManipulation();
            this.perform("selecting index in combo popup", listFinderManipulation);
            JListDriver listDriver = new JListDriver(this.gesturePerformer, listFinderManipulation.list);
            listDriver.selectItem(index);
        }

        public void selectItem(Matcher<? extends Component> matcher) {
            JListFinderManipulation listFinderManipulation = new JListFinderManipulation();
            this.perform("selecting item in combo popup", listFinderManipulation);
            JListDriver listDriver = new JListDriver(this.gesturePerformer, listFinderManipulation.list);
            listDriver.selectItem(matcher);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class JListFinderManipulation
        implements ComponentManipulation<JComponent> {
            JList list;

            private JListFinderManipulation() {
            }

            @Override
            public void manipulate(JComponent component) {
                ComboPopup popup = (ComboPopup)((Object)component);
                this.list = popup.getList();
            }
        }
    }
}

