/*
 * Decompiled with CFR 0.152.
 */
package com.objogate.wl.driver;

import com.objogate.exception.Defect;
import com.objogate.wl.Probe;
import com.objogate.wl.UI;
import com.objogate.wl.driver.AquaFileChooserUIDriver;
import com.objogate.wl.driver.ComponentDriver;
import com.objogate.wl.driver.FileChooserUIDriver;
import com.objogate.wl.driver.GTKFileChooserUIDriver;
import com.objogate.wl.driver.JTextComponentDriver;
import com.objogate.wl.driver.MetalFileChooserUIDriver;
import com.objogate.wl.driver.WindowsFileChooserUIDriver;
import com.objogate.wl.gesture.GesturePerformer;
import java.awt.Component;
import java.awt.HeadlessException;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.text.JTextComponent;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JFileChooserDriver
extends ComponentDriver<JFileChooser> {
    public JFileChooserDriver(GesturePerformer gesturePerformer, JFileChooser chooser) {
        super(gesturePerformer, chooser);
    }

    public JFileChooserDriver(ComponentDriver<? extends Component> parentOrOwner, Matcher<? super JFileChooser> matcher) {
        super(parentOrOwner, JFileChooser.class, matcher);
    }

    private FileChooserUIDriver getRelevantComponentDriver() {
        if (UI.is(UI.METAL)) {
            return new MetalFileChooserUIDriver(this);
        }
        if (UI.is(UI.WINDOWS)) {
            return new WindowsFileChooserUIDriver(this);
        }
        if (UI.is(UI.GTK)) {
            return new GTKFileChooserUIDriver(this);
        }
        if (UI.is(UI.AQUA)) {
            return new AquaFileChooserUIDriver(this);
        }
        throw new UnsupportedOperationException("not known about or supported yet ");
    }

    public void cancel() {
        this.chooserUI().cancel();
    }

    public void approve() {
        this.chooserUI().approve();
    }

    public void enterManually(String someText) {
        JTextComponentDriver<? extends JTextComponent> textComponentDriver = this.chooserUI().textBox();
        textComponentDriver.moveMouseToCenter();
        textComponentDriver.selectAll();
        textComponentDriver.typeText(someText);
    }

    private FileChooserUIDriver chooserUI() {
        this.isShowingOnScreen();
        return this.getRelevantComponentDriver();
    }

    public void desktop() {
        this.chooserUI().desktop();
    }

    public void documents() {
        this.chooserUI().documents();
    }

    public void home() {
        this.chooserUI().home();
    }

    public void upOneFolder() {
        this.chooserUI().upOneFolder();
    }

    public void intoDir(String name) {
        this.chooserUI().intoDir(name);
    }

    public void createNewFolder(String folderName) {
        this.chooserUI().createNewFolder(folderName);
    }

    public void selectFile(String fileName) {
        this.chooserUI().selectFile(fileName);
    }

    public void currentDirectory(final File expectedDir) {
        this.currentDirectory((Matcher<File>)new TypeSafeMatcher<File>(){

            public boolean matchesSafely(File file) {
                try {
                    return file.getCanonicalPath().equals(expectedDir.getCanonicalPath());
                }
                catch (IOException e) {
                    throw new Defect("Cannot get path of directory " + expectedDir);
                }
            }

            public void describeTo(Description description) {
                try {
                    description.appendText(expectedDir.getCanonicalPath());
                }
                catch (IOException e) {
                    throw new Defect("Cannot get path of directory " + expectedDir);
                }
            }
        });
    }

    public void currentDirectory(final Matcher<File> matcher) {
        this.check(new Probe(){
            File currentDirectory;

            public void probe() {
                this.currentDirectory = ((JFileChooser)JFileChooserDriver.this.component().component()).getCurrentDirectory();
            }

            public boolean isSatisfied() {
                return matcher.matches((Object)this.currentDirectory);
            }

            public void describeTo(Description description) {
                description.appendText("current directory matches ").appendDescriptionOf((SelfDescribing)matcher);
            }

            public boolean describeFailureTo(Description description) {
                description.appendText("current directory was ").appendValue((Object)this.currentDirectory);
                return !this.isSatisfied();
            }
        });
    }

    public static JFrame rootFrameFor(Component parentComponent) throws HeadlessException {
        if (parentComponent == null) {
            throw new IllegalArgumentException("Dialog needs a parent");
        }
        if (parentComponent instanceof JFrame) {
            return (JFrame)parentComponent;
        }
        return JFileChooserDriver.rootFrameFor(parentComponent.getParent());
    }
}

