/*
 * Decompiled with CFR 0.152.
 */
package com.objogate.wl.driver;

import com.objogate.wl.ComponentManipulation;
import com.objogate.wl.ComponentSelector;
import com.objogate.wl.Prober;
import com.objogate.wl.Query;
import com.objogate.wl.driver.ComponentDriver;
import com.objogate.wl.driver.ListDriver;
import com.objogate.wl.gesture.GesturePerformer;
import com.objogate.wl.gesture.Gestures;
import com.objogate.wl.matcher.JLabelTextMatcher;
import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.JList;
import javax.swing.ListModel;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JListDriver
extends ComponentDriver<JList>
implements ListDriver {
    public JListDriver(GesturePerformer gesturePerformer, JList component) {
        super(gesturePerformer, component);
    }

    public JListDriver(GesturePerformer gesturePerformer, JList component, Prober prober) {
        super(gesturePerformer, component, prober);
    }

    public JListDriver(GesturePerformer gesturePerformer, ComponentSelector<JList> componentSelector) {
        super(gesturePerformer, componentSelector);
    }

    public JListDriver(GesturePerformer gesturePerformer, ComponentSelector<JList> componentSelector, Prober prober) {
        super(gesturePerformer, componentSelector, prober);
    }

    public JListDriver(ComponentDriver<? extends Component> parentOrOwner, ComponentSelector<JList> componentSelector) {
        super(parentOrOwner, componentSelector);
    }

    public JListDriver(ComponentDriver<? extends Component> parentOrOwner, Class<JList> componentType, Matcher<? super JList> ... matchers) {
        super(parentOrOwner, componentType, matchers);
    }

    @Override
    public void hasSelectedIndex(int expectedIndex) {
        this.has(new Query<JList, Integer>(){

            @Override
            public Integer query(JList component) {
                return component.getSelectedIndex();
            }

            public void describeTo(Description description) {
                description.appendText("selected list index");
            }
        }, Matchers.equalTo((Object)expectedIndex));
    }

    @Override
    public void selectItem(Matcher<? extends Component> matcher) {
        this.selectItem(this.indexOfFirstItemMatching(matcher));
    }

    @Override
    public void selectItem(int index) {
        this.mouseOverCell(index);
        this.performGesture(Gestures.leftClickMouse());
    }

    public void hasItem(Matcher<String> matcher) {
        this.hasRenderedItem((Matcher<? extends Component>)new JLabelTextMatcher(matcher));
    }

    public void hasRenderedItem(Matcher<? extends Component> matcher) {
        this.is(new RenderedItemMatcher(matcher));
    }

    private int indexOfFirstItemMatching(Matcher<? extends Component> matcher) {
        RenderedItemMatcher criteria = new RenderedItemMatcher(matcher);
        this.is(criteria);
        return criteria.indexOfMatchedItem();
    }

    private void mouseOverCell(int index) {
        this.scrollCellToVisible(index);
        CellHeightManipulation cellHeightManipulation = new CellHeightManipulation(index);
        this.perform("locating cell", cellHeightManipulation);
        this.moveMouseToOffset(10, cellHeightManipulation.getY());
    }

    private Component renderedCell(JList component, int i, boolean selected, boolean cellHasFocus) {
        return component.getCellRenderer().getListCellRendererComponent(component, component.getModel().getElementAt(i), i, selected, cellHasFocus);
    }

    public void scrollCellToVisible(final int row) {
        this.perform("scrolling cell to visible", new ComponentManipulation<JList>(){

            @Override
            public void manipulate(JList list) {
                Rectangle r = list.getCellBounds(row, row);
                list.scrollRectToVisible(r);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RenderedItemMatcher
    extends TypeSafeMatcher<JList> {
        private final Matcher<? extends Component> matcher;
        private int index = -1;

        public RenderedItemMatcher(Matcher<? extends Component> matcher) {
            this.matcher = matcher;
        }

        public int indexOfMatchedItem() {
            return this.index;
        }

        public boolean matchesSafely(JList component) {
            ListModel model = component.getModel();
            for (int i = 0; i < model.getSize(); ++i) {
                Component rendered = JListDriver.this.renderedCell(component, i, false, false);
                if (!this.matcher.matches((Object)rendered)) continue;
                this.index = i;
                return true;
            }
            return false;
        }

        public void describeTo(Description description) {
            description.appendDescriptionOf(this.matcher);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CellHeightManipulation
    implements ComponentManipulation<JList> {
        private int y;
        private final int index;

        public CellHeightManipulation(int index) {
            this.index = index;
        }

        public int getY() {
            return this.y;
        }

        @Override
        public void manipulate(JList component) {
            for (int i = 0; i < this.index; ++i) {
                Component rendered = JListDriver.this.renderedCell(component, i, false, false);
                this.y += rendered.getPreferredSize().height;
            }
            this.y += ((JListDriver)JListDriver.this).renderedCell((JList)component, (int)this.index, (boolean)false, (boolean)false).getPreferredSize().height / 2;
        }
    }
}

