/*
 * Decompiled with CFR 0.152.
 */
package com.objogate.wl.driver;

import com.objogate.wl.Query;
import com.objogate.wl.driver.AbstractButtonDriver;
import com.objogate.wl.driver.ComponentDriver;
import com.objogate.wl.driver.JMenuItemDriver;
import com.objogate.wl.gesture.Gestures;
import com.objogate.wl.gesture.RightAngleMouseMoveGesture;
import java.awt.Component;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMenuDriver
extends AbstractButtonDriver<JMenu> {
    public JMenuDriver(ComponentDriver<? extends Component> parentOrOwner, Matcher<? super JMenu> ... matchers) {
        super(parentOrOwner, JMenu.class, matchers);
    }

    public void isShowing() {
        this.has(JMenuDriver.popupVisible(), Matchers.equalTo((Object)true));
    }

    public JMenuDriver selectSubMenu(Matcher<? super JMenu> matcher) {
        JMenuDriver menuDriver = this.subMenu(matcher);
        menuDriver.click();
        return menuDriver;
    }

    public JMenuDriver subMenu(Matcher<? super JMenu> matcher) {
        return new JMenuDriver((ComponentDriver<? extends Component>)this, matcher);
    }

    public JMenuItemDriver selectMenuItem(Matcher<? super JMenuItem> matcher) {
        JMenuItemDriver itemDriver = this.menuItem(matcher);
        itemDriver.click();
        return itemDriver;
    }

    public JMenuItemDriver menuItem(Matcher<? super JMenuItem> matcher) {
        return new JMenuItemDriver((ComponentDriver<? extends Component>)this, matcher);
    }

    private static Query<JMenu, Boolean> popupVisible() {
        return new Query<JMenu, Boolean>(){

            @Override
            public Boolean query(JMenu label) {
                return label.isPopupMenuVisible();
            }

            public void describeTo(Description description) {
                description.appendText("popup menu visibility");
            }
        };
    }

    public void leftClickOn(Matcher<? super JMenuItem> matcher) {
        JMenuItemDriver buttonDriver = this.menuItem(matcher);
        this.prober().check(buttonDriver.component());
        buttonDriver.isShowingOnScreen();
        buttonDriver.performGesture(RightAngleMouseMoveGesture.createVerticalThenHorizontalMouseMoveGesture(buttonDriver.centerOfComponent()), Gestures.clickMouseButton(Gestures.BUTTON1));
    }
}

