/*
 * Decompiled with CFR 0.152.
 */
package com.objogate.wl.driver;

import com.objogate.wl.ComponentManipulation;
import com.objogate.wl.ComponentSelector;
import com.objogate.wl.Prober;
import com.objogate.wl.driver.ComponentDriver;
import com.objogate.wl.gesture.GesturePerformer;
import com.objogate.wl.gesture.MouseMoveAbsoluteGesture;
import com.objogate.wl.gesture.MousePressGesture;
import com.objogate.wl.gesture.MouseReleaseGesture;
import com.objogate.wl.matcher.ScrollBarMatcher;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.BoundedRangeModel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import org.hamcrest.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JScrollbarDriver
extends ComponentDriver<JScrollBar> {
    public JScrollbarDriver(ComponentDriver<? extends Container> containerDriver, Matcher<JScrollBar> ... matchers) {
        super(containerDriver, JScrollBar.class, matchers);
    }

    public JScrollbarDriver(ComponentDriver<? extends Container> containerDriver, JScrollPane pane, int orientation) {
        this(containerDriver, new Matcher[]{new ScrollBarMatcher(pane, orientation)});
    }

    public JScrollbarDriver(GesturePerformer gesturePerformer, JScrollBar component) {
        super(gesturePerformer, component);
    }

    public JScrollbarDriver(GesturePerformer gesturePerformer, JScrollBar component, Prober prober) {
        super(gesturePerformer, component, prober);
    }

    public JScrollbarDriver(GesturePerformer gesturePerformer, ComponentSelector<JScrollBar> componentSelector) {
        super(gesturePerformer, componentSelector);
    }

    public JScrollbarDriver(GesturePerformer gesturePerformer, ComponentSelector<JScrollBar> componentSelector, Prober prober) {
        super(gesturePerformer, componentSelector, prober);
    }

    public JScrollbarDriver(ComponentDriver<? extends Component> parentOrOwner, ComponentSelector<JScrollBar> componentSelector) {
        super(parentOrOwner, componentSelector);
    }

    public JScrollbarDriver(ComponentDriver<? extends Component> parentOrOwner, Class<JScrollBar> componentType, Matcher<? super JScrollBar> ... matchers) {
        super(parentOrOwner, componentType, matchers);
    }

    public void scroll(int movement) {
        ScrollbarLocationManipulation locationManipulation = new ScrollbarLocationManipulation();
        this.perform("locating scroll bar", locationManipulation);
        this.moveMouseToOffset(locationManipulation.getX(), locationManipulation.getY());
        this.performGesture(new MousePressGesture(16));
        if (locationManipulation.getOrientation() == 0) {
            this.performGesture(new MouseMoveAbsoluteGesture(0, movement));
        } else {
            this.performGesture(new MouseMoveAbsoluteGesture(0, movement));
        }
        this.performGesture(new MouseReleaseGesture(16));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ScrollbarLocationManipulation
    implements ComponentManipulation<JScrollBar> {
        private int x;
        private int y;
        private int orientation;

        private ScrollbarLocationManipulation() {
        }

        @Override
        public void manipulate(JScrollBar component) {
            Dimension minimumSize = component.getUI().getMinimumSize(component);
            BoundedRangeModel model = component.getModel();
            double min = model.getMinimum();
            double val = model.getValue();
            double extent = model.getExtent();
            double ratio = extent / ((double)model.getMaximum() - min);
            this.orientation = component.getOrientation();
            if (0 == this.orientation) {
                double width = component.getBounds().getWidth();
                double gripperSize = Math.max(ratio * width, (double)minimumSize.width);
                double midPoint = gripperSize / 2.0 + val * ratio;
                this.y = component.getHeight() / 2;
                this.x = (int)midPoint;
            } else {
                double height = component.getBounds().getHeight();
                double gripperSize = Math.max(ratio * height, (double)minimumSize.height);
                double midPoint = gripperSize / 2.0 + val * ratio;
                this.x = component.getWidth() / 2;
                this.y = (int)midPoint;
            }
        }

        public int getOrientation() {
            return this.orientation;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }
    }
}

