/*
 * Decompiled with CFR 0.152.
 */
package com.objogate.wl.driver;

import com.objogate.wl.ComponentManipulation;
import com.objogate.wl.ComponentSelector;
import com.objogate.wl.Prober;
import com.objogate.wl.driver.ComponentDriver;
import com.objogate.wl.gesture.ComponentEdgeTracker;
import com.objogate.wl.gesture.GesturePerformer;
import com.objogate.wl.gesture.Gestures;
import java.awt.Component;
import javax.swing.JSlider;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSliderDriver
extends ComponentDriver<JSlider> {
    public JSliderDriver(GesturePerformer gesturePerformer, JSlider component) {
        super(gesturePerformer, component);
    }

    public JSliderDriver(GesturePerformer gesturePerformer, JSlider component, Prober prober) {
        super(gesturePerformer, component, prober);
    }

    public JSliderDriver(GesturePerformer gesturePerformer, ComponentSelector<JSlider> jSliderComponentSelector) {
        super(gesturePerformer, jSliderComponentSelector);
    }

    public JSliderDriver(GesturePerformer gesturePerformer, ComponentSelector<JSlider> jSliderComponentSelector, Prober prober) {
        super(gesturePerformer, jSliderComponentSelector, prober);
    }

    public JSliderDriver(ComponentDriver<? extends Component> parentOrOwner, ComponentSelector<JSlider> jSliderComponentSelector) {
        super(parentOrOwner, jSliderComponentSelector);
    }

    public JSliderDriver(ComponentDriver<? extends Component> parentOrOwner, Class<JSlider> componentType, Matcher<? super JSlider> ... matchers) {
        super(parentOrOwner, componentType, matchers);
    }

    public void hasValue(final Matcher<Integer> matcher) {
        this.is(new TypeSafeMatcher<JSlider>(){

            public boolean matchesSafely(JSlider jSlider) {
                return !jSlider.getValueIsAdjusting() && matcher.matches((Object)jSlider.getValue());
            }

            public void describeTo(Description description) {
                description.appendText("slider is not adjusting & has value matching ");
                description.appendDescriptionOf((SelfDescribing)matcher);
            }
        });
    }

    public void hasMaximum(final Matcher<Integer> matcher) {
        this.is(new TypeSafeMatcher<JSlider>(){

            public boolean matchesSafely(JSlider jSlider) {
                return matcher.matches((Object)jSlider.getMaximum());
            }

            public void describeTo(Description description) {
                description.appendText("slider has maximum matching ");
                description.appendDescriptionOf((SelfDescribing)matcher);
            }
        });
    }

    public void hasMinimum(final Matcher<Integer> matcher) {
        this.is(new TypeSafeMatcher<JSlider>(){

            public boolean matchesSafely(JSlider jSlider) {
                return matcher.matches((Object)jSlider.getMinimum());
            }

            public void describeTo(Description description) {
                description.appendText("slider minimum matching ");
                description.appendDescriptionOf((SelfDescribing)matcher);
            }
        });
    }

    public void makeValue(int value) {
        this.hasMaximum((Matcher<Integer>)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(value)));
        this.hasMinimum((Matcher<Integer>)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(value)));
        int currentValue = this.currentValue();
        int count = 0;
        while (count++ < 100 && currentValue != value) {
            if (currentValue < value) {
                this.increment();
            } else {
                this.decrement();
            }
            currentValue = this.currentValue();
        }
        this.hasValue((Matcher<Integer>)Matchers.equalTo((Object)value));
    }

    private int currentValue() {
        SliderValue sliderValue = new SliderValue();
        this.perform("get value", sliderValue);
        return sliderValue.getValue();
    }

    private int orientation() {
        SliderOrientation orientation = new SliderOrientation();
        this.perform("get orientation", orientation);
        return orientation.getOrientation();
    }

    private boolean inverted() {
        SliderInversion inversion = new SliderInversion();
        this.perform("get inversion", inversion);
        return inversion.getInversion();
    }

    public void increment() {
        if (this.inverted()) {
            this.clickBottomOrLeft();
        } else {
            this.clickTopOrRight();
        }
    }

    public void decrement() {
        if (this.inverted()) {
            this.clickTopOrRight();
        } else {
            this.clickBottomOrLeft();
        }
    }

    private void clickTopOrRight() {
        switch (this.orientation()) {
            case 0: {
                this.performGesture(Gestures.moveMouseTo(new ComponentEdgeTracker(this.prober(), this.component(), ComponentEdgeTracker.Edge.Right, -1)));
                break;
            }
            case 1: {
                this.performGesture(Gestures.moveMouseTo(new ComponentEdgeTracker(this.prober(), this.component(), ComponentEdgeTracker.Edge.Top, 1)));
                break;
            }
            default: {
                throw new IllegalStateException("Only can handle Horizontal and Vertical Components!");
            }
        }
        this.performGesture(Gestures.leftClickMouse());
    }

    private void clickBottomOrLeft() {
        switch (this.orientation()) {
            case 0: {
                this.performGesture(Gestures.moveMouseTo(new ComponentEdgeTracker(this.prober(), this.component(), ComponentEdgeTracker.Edge.Left, 1)));
                break;
            }
            case 1: {
                this.performGesture(Gestures.moveMouseTo(new ComponentEdgeTracker(this.prober(), this.component(), ComponentEdgeTracker.Edge.Bottom, -1)));
                break;
            }
            default: {
                throw new IllegalStateException("Only can handle Horizontal and Vertical Components!");
            }
        }
        this.performGesture(Gestures.leftClickMouse());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SliderInversion
    implements ComponentManipulation<JSlider> {
        private boolean inversion;

        private SliderInversion() {
        }

        @Override
        public void manipulate(JSlider component) {
            this.inversion = component.getInverted();
        }

        public boolean getInversion() {
            return this.inversion;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SliderOrientation
    implements ComponentManipulation<JSlider> {
        private int orientation;

        private SliderOrientation() {
        }

        @Override
        public void manipulate(JSlider component) {
            this.orientation = component.getOrientation();
        }

        public int getOrientation() {
            return this.orientation;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SliderValue
    implements ComponentManipulation<JSlider> {
        private int value;

        private SliderValue() {
        }

        @Override
        public void manipulate(JSlider component) {
            this.value = component.getValue();
        }

        public int getValue() {
            return this.value;
        }
    }
}

