/*
 * Decompiled with CFR 0.152.
 */
package com.objogate.wl.driver;

import com.objogate.exception.Defect;
import com.objogate.wl.ComponentManipulation;
import com.objogate.wl.ComponentSelector;
import com.objogate.wl.Prober;
import com.objogate.wl.Query;
import com.objogate.wl.driver.ComponentDriver;
import com.objogate.wl.gesture.GesturePerformer;
import com.objogate.wl.gesture.Gestures;
import com.objogate.wl.gesture.Tracker;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JTabbedPane;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTabbedPaneDriver
extends ComponentDriver<JTabbedPane> {
    public JTabbedPaneDriver(GesturePerformer gesturePerformer, JTabbedPane component) {
        super(gesturePerformer, component);
    }

    public JTabbedPaneDriver(GesturePerformer gesturePerformer, JTabbedPane component, Prober prober) {
        super(gesturePerformer, component, prober);
    }

    public JTabbedPaneDriver(GesturePerformer gesturePerformer, ComponentSelector<JTabbedPane> componentSelector) {
        super(gesturePerformer, componentSelector);
    }

    public JTabbedPaneDriver(GesturePerformer gesturePerformer, ComponentSelector<JTabbedPane> componentSelector, Prober prober) {
        super(gesturePerformer, componentSelector, prober);
    }

    public JTabbedPaneDriver(ComponentDriver<? extends Component> parentOrOwner, ComponentSelector<JTabbedPane> componentSelector) {
        super(parentOrOwner, componentSelector);
    }

    public JTabbedPaneDriver(ComponentDriver<? extends Component> parentOrOwner, Class<JTabbedPane> componentType, Matcher<? super JTabbedPane> ... matchers) {
        super(parentOrOwner, componentType, matchers);
    }

    public void hasTabCount(int expectedCount) {
        this.has(new Query<JTabbedPane, Integer>(){

            @Override
            public Integer query(JTabbedPane component) {
                return component.getTabCount();
            }

            public void describeTo(Description description) {
                description.appendText("tab count");
            }
        }, Matchers.equalTo((Object)expectedCount));
    }

    public void selectTab(final int index) {
        this.performGesture(Gestures.moveMouseTo(new Tracker(){

            public Point target(Point currentLocation) {
                SelectedTabManipulation tabManipulation = new SelectedTabManipulation(index);
                JTabbedPaneDriver.this.perform("finding tab", tabManipulation);
                return tabManipulation.startLocation;
            }
        }), Gestures.clickMouseButton(Gestures.BUTTON1));
    }

    public void hasSelectedTab(int expectedIndex) {
        this.has(new Query<JTabbedPane, Integer>(){

            @Override
            public Integer query(JTabbedPane component) {
                return component.getSelectedIndex();
            }

            public void describeTo(Description description) {
                description.appendText("selected tab");
            }
        }, Matchers.equalTo((Object)expectedIndex));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SelectedTabManipulation
    implements ComponentManipulation<JTabbedPane> {
        private final int index;
        private Point startLocation;

        public SelectedTabManipulation(int index) {
            this.index = index;
        }

        @Override
        public void manipulate(JTabbedPane component) {
            int randomOffset;
            Rectangle rectangle = component.getBounds();
            int tabPlacement = component.getTabPlacement();
            int randomInset = 5;
            if (tabPlacement == 2) {
                randomOffset = randomInset;
            } else if (tabPlacement == 4) {
                randomOffset = rectangle.width - randomInset;
            } else if (tabPlacement == 1) {
                randomOffset = randomInset;
            } else if (tabPlacement == 3) {
                randomOffset = rectangle.height - randomInset;
            } else {
                throw new Defect("");
            }
            if (tabPlacement == 2 || tabPlacement == 4) {
                int y = 0;
                while ((double)y < rectangle.getHeight()) {
                    int i = component.indexAtLocation(randomOffset, y);
                    if (i == this.index) {
                        Point screen;
                        this.startLocation = screen = component.getLocationOnScreen();
                        screen.translate(randomOffset, y);
                        return;
                    }
                    ++y;
                }
            } else {
                int x = 0;
                while ((double)x < rectangle.getWidth()) {
                    int i = component.indexAtLocation(x, randomOffset);
                    if (i == this.index) {
                        Point screen;
                        this.startLocation = screen = component.getLocationOnScreen();
                        screen.translate(x, randomOffset);
                        return;
                    }
                    ++x;
                }
            }
            throw new Defect("Cannot find tab with index " + this.index);
        }
    }
}

