/*
 * Decompiled with CFR 0.152.
 */
package com.objogate.wl.driver;

import com.objogate.wl.ComponentManipulation;
import com.objogate.wl.driver.JTableDriver;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTableCellManipulation
implements ComponentManipulation<JTable> {
    private final int row;
    private Object columnIdentifier;
    private int col;
    private Component cell;
    private Component editorComponent;

    public JTableCellManipulation(int row, int col) {
        this.row = row;
        this.col = col;
    }

    public JTableCellManipulation(int row, Object columnIdentifier) {
        this.row = row;
        this.columnIdentifier = columnIdentifier;
    }

    @Override
    public void manipulate(JTable table) {
        if (this.columnIdentifier != null) {
            this.cell = JTableCellManipulation.render(table, this.row, this.columnIdentifier);
            this.editorComponent = this.editor(table, this.row, this.columnIdentifier);
        } else {
            this.cell = JTableCellManipulation.render(table, this.row, this.col);
            this.editorComponent = this.editor(table, this.row, this.col);
        }
    }

    private Component editor(JTable table, int editorRow, Object editorColumnIdentifier) {
        int viewIndex = JTableCellManipulation.viewIndex(table, editorColumnIdentifier);
        return this.editor(table, editorRow, viewIndex);
    }

    private Component editor(JTable table, int editorRow, int editorCol) {
        TableCellEditor tableCellEditor = table.getCellEditor(editorRow, editorCol);
        return tableCellEditor.getTableCellEditorComponent(table, table.getValueAt(editorRow, editorCol), false, editorRow, editorCol);
    }

    public static Component render(JTable table, int row, Object columIdentifier) {
        int viewIndex = JTableCellManipulation.viewIndex(table, columIdentifier);
        return JTableCellManipulation.render(table, row, viewIndex);
    }

    private static int viewIndex(JTable table, Object columIdentifier) {
        int modelIndex = table.getColumn(columIdentifier).getModelIndex();
        return table.convertColumnIndexToView(modelIndex);
    }

    public static Component render(JTable table, int row, int col) {
        TableCellRenderer cellRenderer = table.getCellRenderer(row, col);
        Object valueToRender = table.getValueAt(row, col);
        boolean isSelected = JTableDriver.arrayContains(table.getSelectedRows(), row);
        boolean hasFocus = isSelected && JTableDriver.arrayContains(table.getSelectedColumns(), col);
        return cellRenderer.getTableCellRendererComponent(table, valueToRender, isSelected, hasFocus, row, col);
    }

    public Component getRenderedCell() {
        return this.cell;
    }

    public Component getEditorComponent() {
        return this.editorComponent;
    }
}

