/*
 * Decompiled with CFR 0.152.
 */
package com.objogate.wl.driver;

import com.objogate.exception.Defect;
import com.objogate.wl.ComponentManipulation;
import com.objogate.wl.ComponentSelector;
import com.objogate.wl.Gesture;
import com.objogate.wl.Prober;
import com.objogate.wl.Query;
import com.objogate.wl.driver.ComponentDriver;
import com.objogate.wl.driver.JTableCellManipulation;
import com.objogate.wl.driver.JTableHeaderDriver;
import com.objogate.wl.gesture.GesturePerformer;
import com.objogate.wl.gesture.Gestures;
import com.objogate.wl.gesture.Tracker;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTableDriver
extends ComponentDriver<JTable> {
    public JTableDriver(ComponentDriver<? extends Container> containerDriver, Matcher<? super JTable> ... matchers) {
        super(containerDriver, JTable.class, matchers);
    }

    public JTableDriver(GesturePerformer gesturePerformer, JTable component) {
        super(gesturePerformer, component);
    }

    public JTableDriver(GesturePerformer gesturePerformer, JTable component, Prober prober) {
        super(gesturePerformer, component, prober);
    }

    public JTableDriver(GesturePerformer gesturePerformer, ComponentSelector<JTable> componentSelector) {
        super(gesturePerformer, componentSelector);
    }

    public JTableDriver(GesturePerformer gesturePerformer, ComponentSelector<JTable> componentSelector, Prober prober) {
        super(gesturePerformer, componentSelector, prober);
    }

    public JTableDriver(ComponentDriver<? extends Component> parentOrOwner, ComponentSelector<JTable> componentSelector) {
        super(parentOrOwner, componentSelector);
    }

    public JTableDriver(ComponentDriver<? extends Component> parentOrOwner, Class<JTable> componentType, Matcher<? super JTable> ... matchers) {
        super(parentOrOwner, componentType, matchers);
    }

    public static boolean arrayContains(int[] stuff, int item) {
        for (int selectedRow : stuff) {
            if (item != selectedRow) continue;
            return true;
        }
        return false;
    }

    public void selectCells(Cell ... cells) {
        this.scrollCellToVisible(cells[0]);
        Gesture[] gestures = new Gesture[cells.length];
        for (int i = 0; i < cells.length; ++i) {
            gestures[i] = Gestures.sequence(Gestures.moveMouseTo(this.pointIn(cells[i])), Gestures.leftClickMouse());
        }
        this.performGesture(Gestures.whileHoldingMultiSelect(Gestures.sequence(gestures)));
    }

    public void selectCell(int row, int col) {
        this.selectCells(JTableDriver.cell(row, col));
    }

    public void selectCell(Matcher<? extends JComponent> matcher) {
        Cell cell = this.hasCell(matcher);
        if (cell == null) {
            throw new Defect("Cannot find cell");
        }
        this.selectCells(cell);
    }

    public void dragMouseOver(Cell start, Cell end) {
        this.scrollCellToVisible(start);
        this.performGesture(Gestures.moveMouseTo(this.pointIn(start)), Gestures.whileHoldingMouseButton(Gestures.BUTTON1, Gestures.moveMouseTo(this.pointIn(end))));
    }

    private Tracker pointIn(Cell start) {
        return this.offset(this.relativeMidpointOfColumn(start.col), this.rowOffset(start.row));
    }

    public Cell hasCell(Matcher<? extends JComponent> matcher) {
        WithCellMatcher withCellMatching = new WithCellMatcher(matcher);
        this.is(withCellMatching);
        return withCellMatching.foundCell;
    }

    public Component editCell(int row, int col) {
        this.mouseOverCell(row, col);
        this.performGesture(Gestures.doubleClickMouse());
        JTableCellManipulation manipulation = new JTableCellManipulation(row, col);
        this.perform("finding cell editor", manipulation);
        return manipulation.getEditorComponent();
    }

    public void mouseOverCell(Cell cell) {
        this.mouseOverCell(cell.row, cell.col);
    }

    public void mouseOverCell(int row, int col) {
        this.scrollCellToVisible(row, col);
        int y = this.rowOffset(row);
        int x = this.relativeMidpointOfColumn(col);
        this.moveMouseToOffset(x, y);
    }

    private int rowOffset(int row) {
        int rowHeight = this.rowHeight();
        return rowHeight * row + rowHeight / 2;
    }

    private int relativeMidpointOfColumn(int col) {
        ColumnManipulation manipulation = new ColumnManipulation(col);
        this.perform("column mid point", manipulation);
        return manipulation.getMidPoint();
    }

    private int rowHeight() {
        JTableRowHeightManipulation tableManipulation = new JTableRowHeightManipulation();
        this.perform("row height", tableManipulation);
        return tableManipulation.getRowHeight();
    }

    public void hasSelectedCells(Cell ... cells) {
        this.is(new SelectedCellsMatcher(cells));
    }

    public void scrollCellToVisible(Cell cell) {
        this.scrollCellToVisible(cell.row, cell.col);
    }

    public void scrollCellToVisible(final int row, final int col) {
        this.perform("table scrolling", new ComponentManipulation<JTable>(){

            @Override
            public void manipulate(JTable table) {
                table.scrollRectToVisible(table.getCellRect(row, col, true));
            }
        });
    }

    public void cellHasColour(int row, Object columnIdentifier, Matcher<Color> foregroundColor, Matcher<Color> backgroundColor) {
        this.cellHasBackgroundColor(row, columnIdentifier, backgroundColor);
        this.cellHasForegroundColor(row, columnIdentifier, foregroundColor);
    }

    public void cellHasColour(int row, int col, Matcher<Color> foregroundColor, Matcher<Color> backgroundColor) {
        this.cellHasBackgroundColor(row, col, backgroundColor);
        this.cellHasForegroundColor(row, col, foregroundColor);
    }

    public void cellHasBackgroundColor(final int row, final Object columnIdentifier, Matcher<Color> backgroundColor) {
        this.has(new Query<JTable, Color>(){

            @Override
            public Color query(JTable component) {
                return JTableCellManipulation.render(component, row, columnIdentifier).getBackground();
            }

            public void describeTo(Description description) {
                description.appendText("background color in cell at " + row + "x" + columnIdentifier);
            }
        }, backgroundColor);
    }

    public void cellHasBackgroundColor(final int row, final int col, Matcher<Color> backgroundColor) {
        this.has(new Query<JTable, Color>(){

            @Override
            public Color query(JTable component) {
                return JTableCellManipulation.render(component, row, col).getBackground();
            }

            public void describeTo(Description description) {
                description.appendText("background colour in cell at " + row + "x" + col);
            }
        }, backgroundColor);
    }

    public void cellHasForegroundColor(final int row, final Object columnIdentifier, Matcher<Color> foregroundColor) {
        this.has(new Query<JTable, Color>(){

            @Override
            public Color query(JTable component) {
                Component rendered = JTableCellManipulation.render(component, row, columnIdentifier);
                return rendered.getForeground();
            }

            public void describeTo(Description description) {
                description.appendText("foreground color in cell at " + row + "x" + columnIdentifier);
            }
        }, foregroundColor);
    }

    public void cellHasForegroundColor(final int row, final int col, Matcher<Color> foregroundColor) {
        this.has(new Query<JTable, Color>(){

            @Override
            public Color query(JTable component) {
                return JTableCellManipulation.render(component, row, col).getForeground();
            }

            public void describeTo(Description description) {
                description.appendText("foreground colour in cell at " + row + "x" + col);
            }
        }, foregroundColor);
    }

    public static Cell cell(int row, int col) {
        return new Cell(row, col);
    }

    public void cellRenderedWithText(int row, Object columnIdentifier, Matcher<String> expectedText) {
        this.has(new CellTextQuery(row, columnIdentifier), expectedText);
    }

    public void cellRenderedWithText(int row, int col, Matcher<String> expectedText) {
        this.has(new CellTextQuery(row, col), expectedText);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CellTextQuery
    implements Query<JTable, String> {
        private final int row;
        private Object columnIdentifier;
        private int col;

        public CellTextQuery(int row, int col) {
            this.row = row;
            this.col = col;
        }

        public CellTextQuery(int row, Object columnIdentifier) {
            this.row = row;
            this.columnIdentifier = columnIdentifier;
        }

        @Override
        public String query(JTable component) {
            Component cell;
            Component component2 = cell = this.columnIdentifier == null ? JTableCellManipulation.render(component, this.row, this.col) : JTableCellManipulation.render(component, this.row, this.columnIdentifier);
            if (cell instanceof JLabel) {
                JLabel label = (JLabel)cell;
                return label.getText();
            }
            throw new Defect("Rendered component in cell " + this.row + "x" + this.col + " is not a JLabel but a " + component.getClass().getName());
        }

        public void describeTo(Description description) {
            description.appendText("text in cell at " + this.row + " x " + this.col);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ColumnManipulation
    implements ComponentManipulation<JTable> {
        private int midpoint;
        private final int col;

        public ColumnManipulation(int col) {
            this.col = col;
        }

        @Override
        public void manipulate(JTable component) {
            this.midpoint = JTableHeaderDriver.ColumnManipulation.midpointOfColumn(this.col, component.getColumnModel());
        }

        public int getMidPoint() {
            return this.midpoint;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JTableRowHeightManipulation
    implements ComponentManipulation<JTable> {
        private int rowHeight;

        private JTableRowHeightManipulation() {
        }

        @Override
        public void manipulate(JTable component) {
            this.rowHeight = component.getRowHeight();
        }

        public int getRowHeight() {
            return this.rowHeight;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class WithCellMatcher
    extends TypeSafeMatcher<JTable> {
        private final Matcher<? extends JComponent> matcher;
        Cell foundCell;

        WithCellMatcher(Matcher<? extends JComponent> matcher) {
            this.matcher = matcher;
        }

        public boolean matchesSafely(JTable table) {
            int rowCount = table.getRowCount();
            int columnCount = table.getColumnCount();
            for (int row = 0; row < rowCount; ++row) {
                for (int col = 0; col < columnCount; ++col) {
                    Component renderedCell = JTableCellManipulation.render(table, row, col);
                    if (!this.matcher.matches((Object)renderedCell)) continue;
                    this.foundCell = new Cell(row, col);
                    return true;
                }
            }
            return false;
        }

        public void describeTo(Description description) {
            description.appendText("with cell ").appendDescriptionOf(this.matcher);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SelectedCellsMatcher
    extends TypeSafeMatcher<JTable> {
        public Cell unselectedCell;
        private final Cell[] cells;

        public SelectedCellsMatcher(Cell ... cells) {
            this.cells = cells;
        }

        public boolean matchesSafely(JTable component) {
            for (Cell cell : this.cells) {
                if (component.isCellSelected(cell.row, cell.col)) continue;
                this.unselectedCell = cell;
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText("cell " + this.unselectedCell + " is not selected");
        }
    }

    public static class Cell {
        public final int row;
        public final int col;

        public Cell(int row, int col) {
            this.row = row;
            this.col = col;
        }

        public String toString() {
            return "r" + this.row + " x " + "c" + this.col;
        }
    }
}

