/*
 * Decompiled with CFR 0.152.
 */
package com.objogate.wl.driver;

import com.objogate.wl.ComponentManipulation;
import com.objogate.wl.ComponentSelector;
import com.objogate.wl.Prober;
import com.objogate.wl.Query;
import com.objogate.wl.driver.ComponentDriver;
import com.objogate.wl.gesture.GesturePerformer;
import com.objogate.wl.gesture.Gestures;
import com.objogate.wl.gesture.MouseMoveGesture;
import com.objogate.wl.gesture.Tracker;
import java.awt.Component;
import java.awt.Point;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTableHeaderDriver
extends ComponentDriver<JTableHeader> {
    public JTableHeaderDriver(GesturePerformer gesturePerformer, JTableHeader component) {
        super(gesturePerformer, component);
    }

    public JTableHeaderDriver(GesturePerformer gesturePerformer, JTableHeader component, Prober prober) {
        super(gesturePerformer, component, prober);
    }

    public JTableHeaderDriver(GesturePerformer gesturePerformer, ComponentSelector<JTableHeader> componentSelector) {
        super(gesturePerformer, componentSelector);
    }

    public JTableHeaderDriver(GesturePerformer gesturePerformer, ComponentSelector<JTableHeader> componentSelector, Prober prober) {
        super(gesturePerformer, componentSelector, prober);
    }

    public JTableHeaderDriver(ComponentDriver<? extends Component> parentOrOwner, ComponentSelector<JTableHeader> componentSelector) {
        super(parentOrOwner, componentSelector);
    }

    public JTableHeaderDriver(ComponentDriver<? extends Component> parentOrOwner, Class<JTableHeader> componentType, Matcher<? super JTableHeader> ... matchers) {
        super(parentOrOwner, componentType, matchers);
    }

    public void moveColumn(Object columnIdentifier, int movement) {
        this.moveColumn(this.getIndexOfColumnIdentifiedBy(columnIdentifier), movement);
    }

    public int getIndexOfColumnIdentifiedBy(Object columnIdentifier) {
        ColumnIndexManipulation manipulation = new ColumnIndexManipulation(columnIdentifier);
        this.perform("index of column", manipulation);
        return manipulation.getIndex();
    }

    public void moveColumn(int index, int movement) {
        this.scrollCellToVisible(-1, index);
        int midpointOfSourceColumn = this.midpointOfColumn(index);
        this.moveMouseToOffset(midpointOfSourceColumn, this.heightOfHeader() / 2);
        int targetColumn = index + movement;
        int midpointOfTargetColumn = this.midpointOfColumn(targetColumn);
        final int translateX = midpointOfTargetColumn - midpointOfSourceColumn;
        this.performGesture(Gestures.whileHoldingMouseButton(Gestures.BUTTON1, Gestures.moveMouseTo(new Tracker(){
            private Point destination;

            public Point target(Point currentLocation) {
                if (this.destination == null) {
                    this.destination = new Point(currentLocation);
                    this.destination.translate(translateX, 0);
                }
                return this.destination;
            }
        })));
    }

    private int heightOfHeader() {
        HeaderHeightManipulation manipulation = new HeaderHeightManipulation();
        this.perform("header height", manipulation);
        return manipulation.getHeight();
    }

    private int midpointOfColumn(int index) {
        ColumnManipulation manipulation = new ColumnManipulation(index);
        this.perform("midpoint of cell", manipulation);
        return manipulation.getMidPoint();
    }

    public void scrollCellToVisible(final int row, final int col) {
        this.perform("scrolling cell", new ComponentManipulation<JTableHeader>(){

            @Override
            public void manipulate(JTableHeader header) {
                JTable table = header.getTable();
                table.scrollRectToVisible(table.getCellRect(row, col, true));
            }
        });
    }

    public void resizeColumn(Object columnIdentifier, int delta) {
        ColumnIndexManipulation manipulation = new ColumnIndexManipulation(columnIdentifier);
        this.perform("index of column", manipulation);
        this.resizeColumn(manipulation.getIndex(), delta);
    }

    public void resizeColumn(int col, final int delta) {
        ColumnManipulation manipulation = new ColumnManipulation(col);
        this.perform("position of column", manipulation);
        int position = manipulation.getLeftSideOfColumn();
        this.moveMouseToOffset(position, this.heightOfHeader() / 2);
        this.performGesture(Gestures.whileHoldingMouseButton(Gestures.BUTTON1, new MouseMoveGesture(new Tracker(){
            Point targetLocation = null;

            public Point target(Point currentLocation) {
                if (this.targetLocation == null) {
                    this.targetLocation = new Point(currentLocation);
                    this.targetLocation.translate(delta, 0);
                }
                return this.targetLocation;
            }
        })));
    }

    public void indexOfColumnIdentifiedBy(Object columnIdentifier, int expectedIndex) {
        final ColumnIndexManipulation manipulation = new ColumnIndexManipulation(columnIdentifier);
        this.has(new Query<JTableHeader, Integer>(){

            @Override
            public Integer query(JTableHeader component) {
                manipulation.manipulate(component);
                return manipulation.getIndex();
            }

            public void describeTo(Description description) {
                description.appendText("column index");
            }
        }, Matchers.equalTo((Object)expectedIndex));
    }

    public void widthOfColumn(Object columnIdentifier, int expectedWidth) {
        int index = this.getIndexOfColumnIdentifiedBy(columnIdentifier);
        this.widthOfColumn(index, expectedWidth);
    }

    public void widthOfColumn(final int columnIndex, int expectedWidth) {
        this.has(new Query<JTableHeader, Integer>(){

            @Override
            public Integer query(JTableHeader component) {
                TableColumn tableColumn = component.getColumnModel().getColumn(columnIndex);
                return tableColumn.getWidth();
            }

            public void describeTo(Description description) {
                description.appendText("column width");
            }
        }, Matchers.equalTo((Object)expectedWidth));
    }

    public int getColumnWidth(Object columnIdentifier) {
        int index = this.getIndexOfColumnIdentifiedBy(columnIdentifier);
        return this.getColumnWidth(index);
    }

    public int getColumnWidth(int col) {
        ColumnManipulation manipulation = new ColumnManipulation(col);
        this.perform("index of column", manipulation);
        return manipulation.getWidth();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HeaderHeightManipulation
    implements ComponentManipulation<JTableHeader> {
        private int height;

        private HeaderHeightManipulation() {
        }

        @Override
        public void manipulate(JTableHeader component) {
            this.height = component.getHeight();
        }

        public int getHeight() {
            return this.height;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ColumnManipulation
    implements ComponentManipulation<JTableHeader> {
        private final int index;
        private int midpointOfColumn;
        private int positionOfColumn;
        private int width;
        private int leftSideOfColumn;

        public ColumnManipulation(int index) {
            this.index = index;
        }

        @Override
        public void manipulate(JTableHeader component) {
            this.midpointOfColumn = ColumnManipulation.midpointOfColumn(this.index, component.getColumnModel());
            this.positionOfColumn = ColumnManipulation.positionOfColumn(this.index, component.getColumnModel());
            TableColumn tableColumn = component.getColumnModel().getColumn(this.index);
            this.width = tableColumn.getWidth();
            this.leftSideOfColumn = this.positionOfColumn + this.width;
        }

        public int getLeftSideOfColumn() {
            return this.leftSideOfColumn;
        }

        public int getWidth() {
            return this.width;
        }

        public int getMidPoint() {
            return this.midpointOfColumn;
        }

        public int getPositionOfColumn() {
            return this.positionOfColumn;
        }

        public static int midpointOfColumn(int index, TableColumnModel columnModel) {
            int x = columnModel.getColumn(index).getWidth() / 2;
            for (int i = 0; i < index; ++i) {
                x += columnModel.getColumn(i).getWidth();
            }
            return x;
        }

        public static int positionOfColumn(int index, TableColumnModel columnModel) {
            int x = 0;
            for (int i = 0; i < index; ++i) {
                x += columnModel.getColumn(i).getWidth();
            }
            return x;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ColumnIndexManipulation
    implements ComponentManipulation<JTableHeader> {
        private int index;
        private final Object columnIdentifier;

        public ColumnIndexManipulation(Object columnIdentifier) {
            this.columnIdentifier = columnIdentifier;
        }

        @Override
        public void manipulate(JTableHeader component) {
            this.index = component.getColumnModel().getColumnIndex(this.columnIdentifier);
        }

        public int getIndex() {
            return this.index;
        }
    }
}

