/*
 * Decompiled with CFR 0.152.
 */
package com.objogate.wl.driver;

import com.objogate.exception.Defect;
import com.objogate.wl.ComponentManipulation;
import com.objogate.wl.ComponentSelector;
import com.objogate.wl.Prober;
import com.objogate.wl.Query;
import com.objogate.wl.driver.ComponentDriver;
import com.objogate.wl.gesture.GesturePerformer;
import com.objogate.wl.gesture.Gestures;
import com.objogate.wl.internal.query.TextQuery;
import java.awt.Component;
import java.awt.Font;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTextComponentDriver<T extends JTextComponent>
extends ComponentDriver<T>
implements TextQuery {
    public JTextComponentDriver(GesturePerformer gesturePerformer, T component) {
        super(gesturePerformer, component);
    }

    public JTextComponentDriver(GesturePerformer gesturePerformer, T component, Prober prober) {
        super(gesturePerformer, component, prober);
    }

    public JTextComponentDriver(GesturePerformer gesturePerformer, ComponentSelector<T> componentSelector) {
        super(gesturePerformer, componentSelector);
    }

    public JTextComponentDriver(GesturePerformer gesturePerformer, ComponentSelector<T> componentSelector, Prober prober) {
        super(gesturePerformer, componentSelector, prober);
    }

    public JTextComponentDriver(ComponentDriver<? extends Component> parentOrOwner, ComponentSelector<T> componentSelector) {
        super(parentOrOwner, componentSelector);
    }

    public JTextComponentDriver(ComponentDriver<? extends Component> parentOrOwner, Class<T> componentType, Matcher<? super T> ... matchers) {
        super(parentOrOwner, componentType, matchers);
    }

    @Override
    public void text(Matcher<String> textMatcher) {
        this.hasText(textMatcher);
    }

    public void hasText(String expectedText) {
        this.hasText((Matcher<String>)Matchers.equalTo((Object)expectedText));
    }

    @Override
    public void hasText(Matcher<String> matcher) {
        this.has(new Query<T, String>(){

            @Override
            public String query(T component) {
                return ((JTextComponent)component).getText();
            }

            public void describeTo(Description description) {
                description.appendText("text");
            }
        }, matcher);
    }

    public void hasSelectedText(String expected) {
        this.hasSelectedText((Matcher<String>)Matchers.equalTo((Object)expected));
    }

    public void hasSelectedText(Matcher<String> matcher) {
        this.has(new Query<T, String>(){

            @Override
            public String query(T component) {
                return ((JTextComponent)component).getSelectedText();
            }

            public void describeTo(Description description) {
                description.appendText("selected text");
            }
        }, matcher);
    }

    public void selectionStartsAt(int index) {
        this.has(new Query<T, Integer>(){

            @Override
            public Integer query(T component) {
                return ((JTextComponent)component).getSelectionStart();
            }

            public void describeTo(Description description) {
                description.appendText("start of selected text");
            }
        }, Matchers.equalTo((Object)index));
    }

    public void selectionEndsAt(int index) {
        this.has(new Query<T, Integer>(){

            @Override
            public Integer query(T component) {
                return ((JTextComponent)component).getSelectionEnd();
            }

            public void describeTo(Description description) {
                description.appendText("end of selected text");
            }
        }, Matchers.equalTo((Object)index));
    }

    public void replaceAllText(String text) {
        this.moveMouseToCenter();
        this.selectAll();
        this.typeText(text);
    }

    public void typeText(String text) {
        this.performGesture(Gestures.type(text));
    }

    public void pressReturn() {
        this.typeText("\n");
    }

    @Override
    public void selectAll() {
        super.selectAll();
    }

    @Override
    public void cut() {
        super.cut();
    }

    @Override
    public void copy() {
        super.copy();
    }

    @Override
    public void paste() {
        super.paste();
    }

    public void replaceText(TextOccurence textOccurence, String replacement) {
        this.selectText(textOccurence);
        this.typeText(replacement);
    }

    public void selectText(TextOccurence textOccurence) {
        this.moveMouseToCenter();
        this.performGesture(Gestures.leftClickMouse());
        TextSearchMatcher search = new TextSearchMatcher(textOccurence);
        this.is(search);
        int start = search.getStart();
        this.moveCaretTo(start);
        int repetitions = search.getEnd() - start;
        this.performGesture(Gestures.whileHoldingKey(16, Gestures.repeat(repetitions, Gestures.typeKey(39))));
    }

    public void moveCaretTo(int targetPosition) {
        int currentPosition = this.getCaretPosition();
        if (currentPosition < targetPosition) {
            this.performGesture(Gestures.repeat(targetPosition - currentPosition, Gestures.typeKey(39)));
        } else {
            this.performGesture(Gestures.repeat(currentPosition - targetPosition, Gestures.typeKey(37)));
        }
    }

    public int getCaretPosition() {
        CarentPositionManipulation positionManipulation = new CarentPositionManipulation();
        this.perform("caret position", positionManipulation);
        return positionManipulation.getPosition();
    }

    public static TextOccurence occurence(int count) {
        return new TextOccurence(count);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TextSearchMatcher
    extends TypeSafeMatcher<JTextComponent> {
        private final int occurence;
        private final String text;
        private int start;
        private int end;

        public TextSearchMatcher(TextOccurence textOccurence) {
            this.occurence = textOccurence.getCount();
            this.text = textOccurence.getText();
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public boolean matchesSafely(JTextComponent component) {
            String s = component.getText();
            int lastIndex = 0;
            for (int i = 0; i < this.occurence; ++i) {
                int index = s.indexOf(this.text, lastIndex);
                if (index == -1) {
                    return false;
                }
                lastIndex = i == this.occurence - 1 ? index : index + this.text.length();
            }
            this.start = lastIndex;
            this.end = this.start + this.text.length();
            return true;
        }

        public void describeTo(Description description) {
            description.appendText("occurence " + this.occurence + " of " + this.text);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CarentPositionManipulation
    implements ComponentManipulation<JTextComponent> {
        private int position;

        private CarentPositionManipulation() {
        }

        @Override
        public void manipulate(JTextComponent component) {
            this.position = component.getCaretPosition();
        }

        public int getPosition() {
            return this.position;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class TextWidthManipulation
    implements ComponentManipulation<JTextComponent> {
        private int width;
        private final int length;
        private final int startIndex;

        public TextWidthManipulation(int startIndex, int length) {
            this.startIndex = startIndex;
            this.length = length;
        }

        @Override
        public void manipulate(JTextComponent component) {
            try {
                String text = component.getText(this.startIndex, this.length);
                Font font = component.getFont();
                this.width = component.getFontMetrics(font).stringWidth(text);
            }
            catch (BadLocationException e) {
                throw new Defect("Cannot get text width", e);
            }
        }

        public int getWidth() {
            return this.width;
        }
    }

    public static class TextOccurence {
        private final int count;
        private String text;

        public TextOccurence(int count) {
            this.count = count;
        }

        public int getCount() {
            return this.count;
        }

        public String getText() {
            return this.text;
        }

        public TextOccurence of(String s) {
            this.text = s;
            return this;
        }
    }
}

