/*
 * Decompiled with CFR 0.152.
 */
package com.objogate.wl.driver;

import com.objogate.wl.ComponentManipulation;
import com.objogate.wl.ComponentSelector;
import com.objogate.wl.Prober;
import com.objogate.wl.driver.ComponentDriver;
import com.objogate.wl.driver.JTextComponentDriver;
import com.objogate.wl.gesture.GesturePerformer;
import com.objogate.wl.gesture.Gestures;
import com.objogate.wl.gesture.Tracker;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import javax.swing.JTextField;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.matchers.TypeSafeMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTextFieldDriver
extends JTextComponentDriver<JTextField> {
    public JTextFieldDriver(GesturePerformer gesturePerformer, JTextField component) {
        super(gesturePerformer, component);
    }

    public JTextFieldDriver(GesturePerformer gesturePerformer, JTextField component, Prober prober) {
        super(gesturePerformer, component, prober);
    }

    public JTextFieldDriver(GesturePerformer gesturePerformer, ComponentSelector<JTextField> componentSelector) {
        super(gesturePerformer, componentSelector);
    }

    public JTextFieldDriver(GesturePerformer gesturePerformer, ComponentSelector<JTextField> componentSelector, Prober prober) {
        super(gesturePerformer, componentSelector, prober);
    }

    public JTextFieldDriver(ComponentDriver<? extends Component> parentOrOwner, ComponentSelector<JTextField> componentSelector) {
        super(parentOrOwner, componentSelector);
    }

    public JTextFieldDriver(ComponentDriver<? extends Component> parentOrOwner, Class<JTextField> componentType, Matcher<? super JTextField> ... matchers) {
        super(parentOrOwner, componentType, matchers);
    }

    public void doubleClickText(JTextComponentDriver.TextOccurence textOccurence) {
        JTextComponentDriver.TextSearchMatcher search = new JTextComponentDriver.TextSearchMatcher(textOccurence);
        this.is(search);
        int end = search.getEnd();
        int scrollOffset = this.scrollPositionIntoView(end);
        int x = this.getTextWidth(0, end - 1) + this.getInsets().left - scrollOffset - 1;
        int y = (int)this.screenBounds().getHeight() / 2;
        this.moveMouseToOffset(x, y);
        this.performGesture(Gestures.doubleClickMouse());
    }

    public void selectWithMouse(JTextComponentDriver.TextOccurence textOccurence) {
        JTextComponentDriver.TextSearchMatcher search = new JTextComponentDriver.TextSearchMatcher(textOccurence);
        this.is(search);
        int textStartIndex = search.getStart();
        final int textEndIndex = search.getEnd();
        int scrollOffset = this.scrollPositionIntoView(textStartIndex + 1);
        int x = this.getTextWidth(0, textStartIndex) + this.getInsets().left - scrollOffset;
        int y = (int)this.screenBounds().getHeight() / 2;
        this.moveMouseToOffset(x, y);
        this.performGesture(Gestures.whileHoldingMouseButton(Gestures.BUTTON1, Gestures.translateMouseTo(new Tracker(){

            public Point target(Point currentLocation) {
                int amount;
                int direction;
                SelectionManipulation selectionManipulation = new SelectionManipulation();
                JTextFieldDriver.this.perform("selection", selectionManipulation);
                int n = direction = selectionManipulation.selectionEnd > textEndIndex ? -1 : 1;
                if (!JTextFieldDriver.this.screenBounds().contains(currentLocation)) {
                    return this.translateHorizontally(currentLocation, direction, 10);
                }
                int numberOfCharactersToMove = selectionManipulation.selectionEnd - textEndIndex;
                int n2 = amount = Math.abs(numberOfCharactersToMove) > 2 ? 5 : 1;
                if (numberOfCharactersToMove != 0) {
                    return this.translateHorizontally(currentLocation, direction, amount);
                }
                return currentLocation;
            }

            private Point translateHorizontally(Point currentLocation, int direction, int amount) {
                Point desiredLocation = new Point(currentLocation);
                desiredLocation.translate(direction * amount, 0);
                return desiredLocation;
            }
        })));
    }

    public Insets getInsets() {
        ComponentInsetsManipulation componentInsetsManipulation = new ComponentInsetsManipulation();
        this.perform("component insets", componentInsetsManipulation);
        return componentInsetsManipulation.getInsets();
    }

    @Override
    public void moveCaretTo(final int position) {
        this.perform("moving caret", new ComponentManipulation<JTextField>(){

            @Override
            public void manipulate(JTextField component) {
                component.setCaretPosition(position);
            }
        });
    }

    private int getTextWidth(int startIndex, int endIndex) {
        JTextComponentDriver.TextWidthManipulation widthManipulation = new JTextComponentDriver.TextWidthManipulation(startIndex, endIndex);
        this.perform("Text width", widthManipulation);
        return widthManipulation.getWidth();
    }

    private int scrollPositionIntoView(int start) {
        this.moveCaretTo(0);
        this.moveCaretTo(start);
        OffsetManipulation offsetManipulation = new OffsetManipulation();
        this.perform("get scroll offset", offsetManipulation);
        return offsetManipulation.getOffset();
    }

    public void focusWithMouse() {
        this.performGesture(Gestures.moveMouseTo(this.centerOfComponent()), Gestures.clickMouseButton(Gestures.BUTTON1));
    }

    public void caretPositionIs(final int caretPosition) {
        this.is(new TypeSafeMatcher<JTextField>(){

            public boolean matchesSafely(JTextField item) {
                return item.getCaretPosition() == caretPosition;
            }

            public void describeTo(Description description) {
                description.appendText("caret position");
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SelectionManipulation
    implements ComponentManipulation<JTextField> {
        int selectionStart;
        int selectionEnd;

        private SelectionManipulation() {
        }

        @Override
        public void manipulate(JTextField component) {
            this.selectionStart = component.getSelectionStart();
            this.selectionEnd = component.getSelectionEnd();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OffsetManipulation
    implements ComponentManipulation<JTextField> {
        public int offset;

        private OffsetManipulation() {
        }

        @Override
        public void manipulate(JTextField component) {
            this.offset = component.getScrollOffset();
        }

        public int getOffset() {
            return this.offset;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ComponentInsetsManipulation
    implements ComponentManipulation<JTextField> {
        private Insets insets;

        private ComponentInsetsManipulation() {
        }

        @Override
        public void manipulate(JTextField component) {
            this.insets = component.getInsets();
        }

        public Insets getInsets() {
            return this.insets;
        }
    }
}

