/*
 * Decompiled with CFR 0.152.
 */
package com.objogate.wl.driver;

import com.objogate.wl.ComponentManipulation;
import com.objogate.wl.ComponentSelector;
import com.objogate.wl.driver.AbstractButtonDriver;
import com.objogate.wl.driver.ComponentDriver;
import com.objogate.wl.driver.FileChooserUIDriver;
import com.objogate.wl.driver.JFileChooserDriver;
import com.objogate.wl.driver.JListDriver;
import com.objogate.wl.driver.JTextFieldDriver;
import com.objogate.wl.gesture.Gestures;
import com.objogate.wl.matcher.ComponentMatchers;
import com.objogate.wl.probe.NthComponentFinder;
import com.objogate.wl.probe.RecursiveComponentFinder;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JTextField;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MetalFileChooserUIDriver
implements FileChooserUIDriver {
    protected JFileChooserDriver parentOrOwner;

    public MetalFileChooserUIDriver(JFileChooserDriver jFileChooserDriver) {
        this.parentOrOwner = jFileChooserDriver;
    }

    @Override
    public void selectFile(String fileName) {
        JListDriver jListDriver = new JListDriver((ComponentDriver<? extends Component>)this.parentOrOwner, JList.class, (Matcher<? super JList>[])new Matcher[0]);
        jListDriver.selectItem((Matcher<? extends Component>)ComponentMatchers.withLabelText((Matcher<String>)Matchers.equalTo((Object)fileName)));
    }

    @Override
    public void intoDir(String directoryName) {
        this.selectFile(directoryName);
        this.parentOrOwner.performGesture(Gestures.doubleClickMouse());
    }

    @Override
    public void cancel() {
        new AbstractButtonDriver<JButton>(this.parentOrOwner, JButton.class, new Matcher[]{ComponentMatchers.withButtonText("Cancel")}).click();
    }

    @Override
    public void approve() {
        final String[] approveButtonText = new String[1];
        this.parentOrOwner.perform("finding the approve button text", new ComponentManipulation<JFileChooser>(){

            @Override
            public void manipulate(JFileChooser component) {
                approveButtonText[0] = component.getApproveButtonText();
            }
        });
        String text = approveButtonText[0] == null ? "Open" : approveButtonText[0];
        new AbstractButtonDriver<JButton>(this.parentOrOwner, JButton.class, new Matcher[]{ComponentMatchers.withButtonText(text), new TypeSafeMatcher<JButton>(){

            public boolean matchesSafely(JButton jButton) {
                return jButton.isVisible();
            }

            public void describeTo(Description description) {
                description.appendText("visible button");
            }
        }}).click();
    }

    public JTextFieldDriver textBox() {
        return new JTextFieldDriver((ComponentDriver<? extends Component>)this.parentOrOwner, JTextField.class, (Matcher<? super JTextField>[])new Matcher[]{Matchers.anything()});
    }

    @Override
    public void home() {
        this.movementIconNumber(1).click();
    }

    @Override
    public void documents() {
        throw new UnsupportedOperationException("There is no 'My Documents' button in the Metal L&F");
    }

    @Override
    public void desktop() {
        throw new UnsupportedOperationException("There is no 'Desktop' button in the Metal L&F");
    }

    @Override
    public void createNewFolder(String folderName) {
        this.movementIconNumber(2).click();
        JTextFieldDriver folderEntry = new JTextFieldDriver((ComponentDriver<? extends Component>)this.parentOrOwner, (ComponentSelector<JTextField>)this.parentOrOwner.the(JTextField.class, ComponentMatchers.withFocus()));
        folderEntry.moveMouseToCenter();
        folderEntry.typeText(folderName);
        folderEntry.typeText("\n");
    }

    @Override
    public void upOneFolder() {
        this.movementIconNumber(0).click();
    }

    private AbstractButtonDriver<JButton> movementIconNumber(int toChoose) {
        NthComponentFinder<JButton> finder = new NthComponentFinder<JButton>(new RecursiveComponentFinder<JButton>(JButton.class, Matchers.anything(), this.parentOrOwner.component()), toChoose);
        return new AbstractButtonDriver<JButton>(this.parentOrOwner, finder);
    }
}

