/*
 * Decompiled with CFR 0.152.
 */
package com.objogate.wl.driver;

import com.objogate.wl.driver.AbstractButtonDriver;
import com.objogate.wl.driver.JFileChooserDriver;
import com.objogate.wl.driver.MetalFileChooserUIDriver;
import javax.swing.JToggleButton;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

class WindowsFileChooserUIDriver
extends MetalFileChooserUIDriver {
    private static final String DESKTOP_BUTTON_TEXT = "Desktop";
    private static final String HOME_BUTTON_TEXT = "My Documents";

    public WindowsFileChooserUIDriver(JFileChooserDriver jFileChooserDriver) {
        super(jFileChooserDriver);
    }

    public void desktop() {
        new AbstractButtonDriver<JToggleButton>(this.parentOrOwner, JToggleButton.class, new Matcher[]{new HtmlToggleButtonMatcher(DESKTOP_BUTTON_TEXT)}).click();
    }

    public void home() {
        throw new UnsupportedOperationException("There is no 'Home' button in the Windows L&F");
    }

    public void documents() {
        new AbstractButtonDriver<JToggleButton>(this.parentOrOwner, JToggleButton.class, new Matcher[]{new HtmlToggleButtonMatcher(HOME_BUTTON_TEXT)}).click();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HtmlToggleButtonMatcher
    extends TypeSafeMatcher<JToggleButton> {
        private String desktopButtonText;

        public HtmlToggleButtonMatcher(String desktopButtonText) {
            this.desktopButtonText = desktopButtonText;
        }

        public boolean matchesSafely(JToggleButton jButton) {
            return jButton.getText().equals(this.wrapInWindowsHtml(this.desktopButtonText));
        }

        public void describeTo(Description description) {
            description.appendText("Button with text '" + this.wrapInWindowsHtml(this.desktopButtonText) + "'");
        }

        private String wrapInWindowsHtml(String buttonText) {
            return "<html><center>" + buttonText + "</center></html>";
        }
    }
}

