/*
 * Decompiled with CFR 0.152.
 */
package com.objogate.wl.gesture;

import com.objogate.wl.ComponentSelector;
import com.objogate.wl.Prober;
import com.objogate.wl.gesture.ComponentScreenBoundsProbe;
import com.objogate.wl.gesture.Tracker;
import java.awt.Component;
import java.awt.Point;
import org.hamcrest.Description;
import org.hamcrest.SelfDescribing;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentEdgeTracker
implements Tracker,
SelfDescribing {
    private final Prober prober;
    private Edge edge;
    private int offset;
    private final ComponentScreenBoundsProbe probe;

    public ComponentEdgeTracker(Prober prober, ComponentSelector<? extends Component> componentSelector, Edge edge, int offset) {
        this.prober = prober;
        this.edge = edge;
        this.offset = offset;
        this.probe = new ComponentScreenBoundsProbe(componentSelector);
    }

    @Override
    public Point target(Point currentLocation) {
        this.prober.check(this.probe);
        switch (this.edge) {
            case Left: {
                return new Point((int)this.probe.bounds.getMinX() + this.offset, (int)this.probe.bounds.getCenterY());
            }
            case Right: {
                return new Point((int)this.probe.bounds.getMaxX() + this.offset, (int)this.probe.bounds.getCenterY());
            }
            case Top: {
                return new Point((int)this.probe.bounds.getCenterX(), (int)this.probe.bounds.getMinY() + this.offset);
            }
            case Bottom: {
                return new Point((int)this.probe.bounds.getCenterX(), (int)this.probe.bounds.getMaxY() + this.offset);
            }
        }
        throw new UnsupportedOperationException("do not support that edge yet");
    }

    public void describeTo(Description description) {
        description.appendText("center of ");
        description.appendDescriptionOf((SelfDescribing)this.probe);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Edge {
        Left,
        Right,
        Top,
        Bottom;

    }
}

