/*
 * Decompiled with CFR 0.152.
 */
package com.objogate.wl.gesture;

import com.objogate.wl.ComponentSelector;
import com.objogate.wl.Probe;
import java.awt.Component;
import java.awt.Rectangle;
import org.hamcrest.Description;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ComponentScreenBoundsProbe
implements Probe {
    private final ComponentSelector<? extends Component> componentSelector;
    public Rectangle bounds;

    public ComponentScreenBoundsProbe(ComponentSelector<? extends Component> componentSelector) {
        this.componentSelector = componentSelector;
    }

    @Override
    public void probe() {
        this.componentSelector.probe();
        if (this.componentSelector.components().isEmpty()) {
            this.bounds = null;
            return;
        }
        Component component = this.componentSelector.component();
        this.bounds = component.isShowing() ? new Rectangle(component.getLocationOnScreen(), component.getSize()) : null;
    }

    @Override
    public boolean isSatisfied() {
        return this.bounds != null && this.bounds.getWidth() > 0.0 && this.bounds.getHeight() > 0.0;
    }

    public void describeTo(Description description) {
        description.appendText("screen dimensions of ");
        description.appendDescriptionOf(this.componentSelector);
    }

    @Override
    public boolean describeFailureTo(Description description) {
        if (this.componentSelector.describeFailureTo(description)) {
            return true;
        }
        description.appendText("\n    which had no screen dimensions");
        return true;
    }
}

