/*
 * Decompiled with CFR 0.152.
 */
package com.objogate.wl.gesture;

import com.objogate.wl.Gesture;
import com.objogate.wl.Platform;
import com.objogate.wl.UI;
import com.objogate.wl.gesture.GestureSequence;
import com.objogate.wl.gesture.KeyPressGesture;
import com.objogate.wl.gesture.KeyReleaseGesture;
import com.objogate.wl.gesture.ModifierKeyGesture;
import com.objogate.wl.gesture.MouseMoveGesture;
import com.objogate.wl.gesture.MousePressGesture;
import com.objogate.wl.gesture.MouseReleaseGesture;
import com.objogate.wl.gesture.MouseTranslateGesture;
import com.objogate.wl.gesture.MouseWheelGesture;
import com.objogate.wl.gesture.RepetitionGesture;
import com.objogate.wl.gesture.Tracker;
import com.objogate.wl.gesture.TypeTextGesture;
import com.objogate.wl.gesture.WaitGesture;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Gestures {
    public static int BUTTON1 = 16;
    public static int BUTTON2 = 8;
    public static int BUTTON3 = 4;
    public static int SHIFT = 1;
    public static int CONTROL = 2;
    public static int ALT = 8;
    public static int ALT_GRAPH = 32;
    public static int META = 4;
    private static final int MID_KEY_PRESS_DELAY = 50;
    private static final int MID_MOUSE_CLICK_DELAY = 100;
    private static final int MID_DOUBLE_CLICK_DELAY = 5;
    public static final int MIN_TIME_TO_WAIT_TO_AVOID_DOUBLE_CLICK = 1000;

    public static Gesture sequence(Gesture ... gestures) {
        return new GestureSequence(Arrays.asList(gestures));
    }

    public static Gesture pause(int waitMs) {
        return new WaitGesture(waitMs);
    }

    public static Gesture repeat(int repetitions, Gesture gesture) {
        return new RepetitionGesture(repetitions, gesture);
    }

    public static Gesture pressMouse(int buttons) {
        return new MousePressGesture(buttons);
    }

    public static Gesture releaseMouse(int buttons) {
        return new MouseReleaseGesture(buttons);
    }

    public static Gesture moveMouseWheel(int amount) {
        return new MouseWheelGesture(amount);
    }

    public static Gesture clickMouseButton(int buttons) {
        return Gestures.sequence(Gestures.pressMouse(buttons), Gestures.pause(100), Gestures.releaseMouse(buttons));
    }

    public static Gesture leftClickMouse() {
        return Gestures.clickMouseButton(BUTTON1);
    }

    public static Gesture rightClickMouse() {
        return Gestures.clickMouseButton(BUTTON2);
    }

    public static Gesture doubleClickMouse() {
        Gesture leftClick = Gestures.clickMouseButton(BUTTON1);
        return Gestures.sequence(leftClick, Gestures.pause(5), leftClick);
    }

    public static Gesture moveMouseTo(Tracker tracker) {
        return new MouseMoveGesture(tracker);
    }

    public static Gesture translateMouseTo(Tracker tracker) {
        return new MouseTranslateGesture(tracker);
    }

    public static Gesture pressKey(int keyCode) {
        return new KeyPressGesture(keyCode);
    }

    public static Gesture releaseKey(int keyCode) {
        return new KeyReleaseGesture(keyCode);
    }

    public static Gesture typeKey(int keyCode) {
        return Gestures.sequence(Gestures.pressKey(keyCode), Gestures.pause(50), Gestures.releaseKey(keyCode));
    }

    public static Gesture type(String text) {
        return new TypeTextGesture(text);
    }

    public static Gesture whileHoldingKey(int keyCode, Gesture gesture) {
        return Gestures.sequence(Gestures.pressKey(keyCode), gesture, Gestures.releaseKey(keyCode));
    }

    public static Gesture whileHoldingMouseButton(int buttons, Gesture gesture) {
        return Gestures.sequence(Gestures.pressMouse(buttons), gesture, Gestures.pause(100), Gestures.releaseMouse(buttons));
    }

    public static Gesture withModifierKey(int modifierKeyCode, Gesture modifiedGesture) {
        return new ModifierKeyGesture(modifierKeyCode, modifiedGesture);
    }

    public static Gesture withModifierMask(int modifierMask, Gesture modifiedGesture) {
        Gesture result = modifiedGesture;
        if ((modifierMask & SHIFT) != 0) {
            result = Gestures.withModifierKey(16, result);
        }
        if ((modifierMask & CONTROL) != 0) {
            result = Gestures.withModifierKey(17, result);
        }
        if ((modifierMask & ALT) != 0) {
            result = Gestures.withModifierKey(18, result);
        }
        if ((modifierMask & ALT_GRAPH) != 0) {
            result = Gestures.withModifierKey(65406, result);
        }
        if ((modifierMask & META) != 0) {
            result = Gestures.withModifierKey(157, result);
        }
        return result;
    }

    public static Gesture whileHoldingMultiSelect(Gesture gesture) {
        int menuShortcutKeyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        if (UI.is(UI.METAL) && Platform.is(Platform.Mac)) {
            menuShortcutKeyMask = META;
        }
        return Gestures.withModifierMask(menuShortcutKeyMask, gesture);
    }

    public static Gesture shortcut(Gesture gesture) {
        int menuShortcutKeyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        if (UI.is(UI.METAL) && Platform.is(Platform.Mac)) {
            menuShortcutKeyMask = CONTROL;
        }
        return Gestures.withModifierMask(menuShortcutKeyMask, gesture);
    }

    public static Gesture shortcut(int keyCode) {
        return Gestures.shortcut(Gestures.typeKey(keyCode));
    }

    public static Gesture cut() {
        return Gestures.shortcut(88);
    }

    public static Gesture copy() {
        return Gestures.shortcut(67);
    }

    public static Gesture paste() {
        return Gestures.shortcut(86);
    }

    public static Gesture selectAll() {
        return Gestures.shortcut(65);
    }

    public static List<String> buttonListFor(int buttons) {
        ArrayList<String> list = new ArrayList<String>();
        if ((buttons & BUTTON1) != 0) {
            list.add("Left");
        }
        if ((buttons & BUTTON2) != 0) {
            list.add("Middle");
        }
        if ((buttons & BUTTON3) != 0) {
            list.add("Right");
        }
        return list;
    }
}

