/*
 * Decompiled with CFR 0.152.
 */
package com.objogate.wl.gesture;

import com.objogate.exception.Defect;
import com.objogate.math.CubicBezierCurve2D;
import com.objogate.math.Vector2D;
import com.objogate.wl.Gesture;
import com.objogate.wl.gesture.Tracker;
import com.objogate.wl.robot.Automaton;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import org.hamcrest.Description;

public class MouseMoveGesture
implements Gesture {
    private static final double ANIMATE_STEP = 0.02;
    private int animationDelayMs = 25;
    private final Tracker tracker;

    public MouseMoveGesture(Tracker tracker) {
        this.tracker = tracker;
    }

    public void performGesture(Automaton automaton) {
        Vector2D destination = null;
        for (double t = 0.0; t < 1.0; t += 0.02) {
            Vector2D start;
            Point trackerDestination;
            Point currentLocation = automaton.getPointerLocation();
            if (currentLocation.equals(trackerDestination = this.getDestination(currentLocation))) {
                return;
            }
            destination = new Vector2D(this.clipToScreen(trackerDestination));
            Vector2D movement = destination.sub(start = new Vector2D(automaton.getPointerLocation()));
            if (movement.magnitude() < 2.0) break;
            Vector2D controlA = start.add(movement.mul(0.7));
            Vector2D controlB = start.add(movement.mul(0.8));
            CubicBezierCurve2D animation = new CubicBezierCurve2D(start, controlA, controlB, destination);
            this.moveMouse(automaton, animation.p(t));
            automaton.delay(this.animationDelayMs);
        }
        this.moveMouse(automaton, destination);
        automaton.delay(200);
    }

    private Point getDestination(Point currentLocation) {
        try {
            return this.tracker.target(currentLocation);
        }
        catch (AssertionError e) {
            throw new Defect(this.tracker + " returned null", (Throwable)((Object)e));
        }
    }

    private Point clipToScreen(Point p) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        return new Point(this.clip(p.x, screenSize.width - 1), this.clip(p.y, screenSize.height - 1));
    }

    private int clip(int n, int maxN) {
        return Math.max(0, Math.min(n, maxN));
    }

    private void moveMouse(Automaton automaton, Vector2D d) {
        automaton.mouseMove((int)d.x(), (int)d.y());
    }

    public void describeTo(Description description) {
        description.appendText("move mouse to ");
        description.appendValue((Object)this.tracker);
    }
}

