/*
 * Decompiled with CFR 0.152.
 */
package com.objogate.wl.gesture;

import com.objogate.wl.Gesture;
import com.objogate.wl.gesture.Tracker;
import com.objogate.wl.robot.Automaton;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import org.hamcrest.Description;

public class MouseTranslateGesture
implements Gesture {
    private int animationDelayMs = 25;
    private final Tracker tracker;

    public MouseTranslateGesture(Tracker tracker) {
        this.tracker = tracker;
    }

    public void performGesture(Automaton automaton) {
        Point trackerDestination;
        Point currentLocation;
        while (!(currentLocation = automaton.getPointerLocation()).equals(trackerDestination = this.tracker.target(currentLocation))) {
            automaton.delay(this.animationDelayMs);
            this.moveMouse(automaton, this.clipToScreen(trackerDestination));
        }
        return;
    }

    private Point clipToScreen(Point p) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        return new Point(this.clip(p.x, screenSize.width - 1), this.clip(p.y, screenSize.height - 1));
    }

    private int clip(int n, int maxN) {
        return Math.max(0, Math.min(n, maxN));
    }

    private void moveMouse(Automaton automaton, Point d) {
        automaton.mouseMove((int)d.getX(), (int)d.getY());
    }

    public void describeTo(Description description) {
        description.appendText("move mouse to ");
        description.appendValue((Object)this.tracker);
    }
}

