/*
 * Decompiled with CFR 0.152.
 */
package com.objogate.wl.gesture;

import com.objogate.wl.Gesture;
import com.objogate.wl.gesture.MouseMoveGesture;
import com.objogate.wl.gesture.Tracker;
import com.objogate.wl.robot.Automaton;
import java.awt.Point;
import org.hamcrest.Description;

public class RightAngleMouseMoveGesture
implements Gesture {
    private final Tracker tracker;
    private final Mode mode;

    private RightAngleMouseMoveGesture(Tracker tracker, Mode mode) {
        this.tracker = tracker;
        this.mode = mode;
    }

    public void performGesture(Automaton automaton) {
        if (this.mode == Mode.H_THEN_V) {
            new MouseMoveGesture(new HorizontalOnlyTracker()).performGesture(automaton);
            new MouseMoveGesture(new VerticalOnlyTracker()).performGesture(automaton);
        } else {
            new MouseMoveGesture(new VerticalOnlyTracker()).performGesture(automaton);
            new MouseMoveGesture(new HorizontalOnlyTracker()).performGesture(automaton);
        }
    }

    public void describeTo(Description description) {
        description.appendText("Move Horizontally, then Vertically to ");
        description.appendValue((Object)this.tracker);
    }

    public static RightAngleMouseMoveGesture createVerticalThenHorizontalMouseMoveGesture(Tracker tracker) {
        return new RightAngleMouseMoveGesture(tracker, Mode.V_THEN_H);
    }

    public static RightAngleMouseMoveGesture createHorizontalThenVerticalMouseMoveGesture(Tracker tracker) {
        return new RightAngleMouseMoveGesture(tracker, Mode.H_THEN_V);
    }

    public class VerticalOnlyTracker
    implements Tracker {
        public Point target(Point currentLocation) {
            Point target = RightAngleMouseMoveGesture.this.tracker.target(currentLocation);
            return new Point(currentLocation.x, target.y);
        }
    }

    public class HorizontalOnlyTracker
    implements Tracker {
        public Point target(Point currentLocation) {
            Point target = RightAngleMouseMoveGesture.this.tracker.target(currentLocation);
            return new Point(target.x, currentLocation.y);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Mode {
        H_THEN_V,
        V_THEN_H;

    }
}

