/*
 * Decompiled with CFR 0.152.
 */
package com.objogate.wl.internal;

import java.awt.Color;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class RenderedTable {
    private final JTable table;
    public static final int HEADER = -1;

    public RenderedTable(JTable table) {
        this.table = table;
    }

    public String getTextFromCell(int rowIndex, Object propertyId) {
        return this.renderCell(rowIndex, this.indexOf(propertyId)).getText();
    }

    public int getJustificationOfCell(int rowIndex, Object propertyId) {
        return this.renderCell(rowIndex, this.indexOf(propertyId)).getHorizontalAlignment();
    }

    private JLabel renderCell(int rowIndex, int columnIndex) {
        if (rowIndex == -1) {
            return this.renderHeaderCell(rowIndex, columnIndex);
        }
        return this.renderTableCell(rowIndex, columnIndex);
    }

    private JLabel renderTableCell(int rowIndex, int columnIndex) {
        TableCellRenderer cellRenderer = this.table.getCellRenderer(rowIndex, columnIndex);
        Object cellValue = this.table.getValueAt(rowIndex, columnIndex);
        ListSelectionModel selectionModel = this.table.getSelectionModel();
        boolean selected = rowIndex >= selectionModel.getMinSelectionIndex() && rowIndex <= selectionModel.getMaxSelectionIndex();
        return (JLabel)cellRenderer.getTableCellRendererComponent(this.table, cellValue, selected, false, rowIndex, columnIndex);
    }

    private JLabel renderHeaderCell(int rowIndex, int columnIndex) {
        TableCellRenderer renderer = this.table.getTableHeader().getDefaultRenderer();
        int modelIndex = this.table.convertColumnIndexToModel(columnIndex);
        TableColumn tableColumn = this.table.getColumnModel().getColumn(modelIndex);
        Object cellValue = tableColumn.getHeaderValue();
        return (JLabel)renderer.getTableCellRendererComponent(this.table, cellValue, false, false, rowIndex, columnIndex);
    }

    public Color getBackgroundColour(int rowIndex, int columnIndex) {
        return this.renderCell(rowIndex, columnIndex).getBackground();
    }

    public Color getForegroundColour(int rowIndex, int columnIndex) {
        return this.renderCell(rowIndex, columnIndex).getForeground();
    }

    public Font getFont(int rowIndex, int columnIndex) {
        return this.renderCell(rowIndex, columnIndex).getFont();
    }

    public void selectRow(int rowIndex) {
        this.table.getSelectionModel().setSelectionInterval(rowIndex, rowIndex);
    }

    public int indexOf(Object columnIdentifier) {
        return this.table.getColumnModel().getColumnIndex(columnIdentifier);
    }

    public void moveColumnTo(Object propertyId, int toIndex) {
        this.table.getColumnModel().moveColumn(this.indexOf(propertyId), toIndex);
    }

    public void moveColumnToEnd(Object column) {
        this.moveColumnTo(column, this.table.getColumnCount() - 1);
    }
}

