/*
 * Decompiled with CFR 0.152.
 */
package com.objogate.wl.keyboard;

import com.objogate.wl.Gesture;
import com.objogate.wl.Platform;
import com.objogate.wl.SystemProperties;
import com.objogate.wl.gesture.Gestures;
import java.awt.im.InputContext;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.KeyStroke;

public class KeyboardLayout
implements SystemProperties {
    private final Map<Character, KeyStroke> keyStrokes = new HashMap<Character, KeyStroke>();
    private final String name;

    private KeyboardLayout(String name, URL resource) throws IOException {
        this.name = name;
        this.initialiseDefaults();
        this.parseKeyStrokes(resource);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name + " keyboard layout";
    }

    public Gesture gestureForTyping(char ch) {
        KeyStroke keyStroke = this.keyStrokeFor(ch);
        return Gestures.withModifierMask(keyStroke.getModifiers(), Gestures.typeKey(keyStroke.getKeyCode()));
    }

    private KeyStroke keyStrokeFor(char ch) {
        KeyStroke keyStroke = this.keyStrokes.get(Character.valueOf(ch));
        if (keyStroke != null) {
            return keyStroke;
        }
        throw new IllegalArgumentException("no stroke available for character '" + ch + "'");
    }

    public static KeyboardLayout getDefaultKeyboardLayout() {
        String layoutName = System.getProperty("com.objogate.wl.keyboard", InputContext.getInstance().getLocale().getCountry());
        return KeyboardLayout.getKeyboardLayout(layoutName);
    }

    public static KeyboardLayout getKeyboardLayout(String layoutName) {
        URL configURL = KeyboardLayout.class.getResource(layoutName + ".keyboard");
        if (configURL == null) {
            throw new IllegalArgumentException("keyboard layout " + layoutName + " not available.");
        }
        try {
            return new KeyboardLayout(layoutName, configURL);
        }
        catch (IOException e) {
            throw new IllegalStateException("could not parse " + layoutName + " keyboard layout properties");
        }
    }

    private void initialiseDefaults() {
        char ch;
        for (ch = '0'; ch <= '9'; ch = (char)(ch + '\u0001')) {
            this.keyStrokes.put(Character.valueOf(ch), KeyStroke.getKeyStroke((int)ch, 0));
        }
        for (ch = 'A'; ch <= 'Z'; ch = (char)(ch + '\u0001')) {
            this.keyStrokes.put(Character.valueOf(Character.toLowerCase(ch)), KeyStroke.getKeyStroke((int)ch, 0));
            this.keyStrokes.put(Character.valueOf(ch), KeyStroke.getKeyStroke((int)ch, 1));
        }
        this.keyStrokes.put(Character.valueOf('\n'), KeyStroke.getKeyStroke(10, 0));
        this.keyStrokes.put(Character.valueOf('\t'), KeyStroke.getKeyStroke(9, 0));
        this.keyStrokes.put(Character.valueOf('\b'), KeyStroke.getKeyStroke(8, 0));
        this.keyStrokes.put(Character.valueOf(' '), KeyStroke.getKeyStroke(32, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseKeyStrokes(URL resource) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(resource.openStream()));
        try {
            this.parseKeyStrokes(in);
        }
        finally {
            in.close();
        }
    }

    private void parseKeyStrokes(BufferedReader in) throws IOException {
        String line;
        while ((line = in.readLine()) != null) {
            char ch = line.charAt(0);
            String keyStrokeSpec = line.substring(2);
            this.keyStrokes.put(Character.valueOf(ch), KeyStroke.getKeyStroke(keyStrokeSpec));
        }
    }

    static {
        if (System.getProperty("com.objogate.wl.keyboard") == null && Platform.is(Platform.Mac)) {
            System.setProperty("com.objogate.wl.keyboard", "MAC.GB");
        }
    }
}

