/*
 * Decompiled with CFR 0.152.
 */
package com.objogate.wl.probe;

import com.objogate.wl.ComponentFinder;
import com.objogate.wl.ComponentSelector;
import java.awt.Component;
import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentAssertionProbe<T extends Component>
implements ComponentFinder<T> {
    private final ComponentSelector<T> selector;
    private final Matcher<? super T> assertion;
    private boolean assertionMet = false;

    public ComponentAssertionProbe(ComponentSelector<T> selector, Matcher<? super T> assertion) {
        this.assertion = assertion;
        this.selector = selector;
    }

    @Override
    public List<T> components() {
        return this.selector.components();
    }

    @Override
    public void probe() {
        this.selector.probe();
        this.assertionMet = this.selector.isSatisfied() && this.assertion.matches(this.selector.component());
    }

    @Override
    public boolean isSatisfied() {
        return this.assertionMet;
    }

    public void describeTo(Description description) {
        description.appendDescriptionOf(this.selector).appendText("\nand check that it is ").appendDescriptionOf(this.assertion);
    }

    @Override
    public boolean describeFailureTo(Description description) {
        if (this.selector.describeFailureTo(description)) {
            return true;
        }
        description.appendText("\n   it ").appendText(this.assertionMet ? "is " : "is not ").appendDescriptionOf(this.assertion);
        return !this.assertionMet;
    }
}

