/*
 * Decompiled with CFR 0.152.
 */
package com.objogate.wl.probe;

import com.objogate.wl.ComponentSelector;
import com.objogate.wl.Probe;
import com.objogate.wl.Query;
import java.awt.Component;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentPropertyAssertionProbe<C extends Component, P>
implements Probe {
    private final ComponentSelector<C> selector;
    private final Query<? super C, P> propertyValueQuery;
    private final Matcher<? super P> propertyValueMatcher;
    private P propertyValue;

    public ComponentPropertyAssertionProbe(ComponentSelector<C> selector, Query<? super C, P> propertyValueQuery, Matcher<? super P> propertyValueMatcher) {
        this.selector = selector;
        this.propertyValueQuery = propertyValueQuery;
        this.propertyValueMatcher = propertyValueMatcher;
    }

    @Override
    public void probe() {
        this.selector.probe();
        if (this.selector.isSatisfied()) {
            this.propertyValue = this.propertyValueQuery.query(this.selector.component());
        }
    }

    @Override
    public boolean isSatisfied() {
        return this.selector.isSatisfied() && this.propertyValueMatcher.matches(this.propertyValue);
    }

    public void describeTo(Description description) {
        description.appendDescriptionOf(this.selector).appendText("\nand check that its ").appendDescriptionOf(this.propertyValueQuery).appendText(" is ").appendDescriptionOf(this.propertyValueMatcher);
    }

    @Override
    public boolean describeFailureTo(Description description) {
        if (this.selector.describeFailureTo(description)) {
            return true;
        }
        description.appendText("\n    ").appendDescriptionOf(this.propertyValueQuery).appendText(" was ").appendValue(this.propertyValue);
        return !this.propertyValueMatcher.matches(this.propertyValue);
    }
}

