/*
 * Decompiled with CFR 0.152.
 */
package com.objogate.wl.probe;

import com.objogate.exception.Defect;
import com.objogate.wl.ComponentSelector;
import com.objogate.wl.Probe;
import java.awt.Component;
import java.awt.Rectangle;
import org.hamcrest.Description;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentRelativePositionProbe
implements Probe {
    private final ComponentSelector<? extends Component> selectorA;
    private final ComponentSelector<? extends Component> selectorB;
    private final RelativePosition relativePosition;
    private boolean satisfied = false;

    public ComponentRelativePositionProbe(ComponentSelector<? extends Component> selectorA, RelativePosition position, ComponentSelector<? extends Component> selectorB) {
        this.selectorA = selectorA;
        this.relativePosition = position;
        this.selectorB = selectorB;
    }

    @Override
    public void probe() {
        this.selectorA.probe();
        this.selectorB.probe();
        if (this.selectorA.isSatisfied() && this.selectorB.isSatisfied()) {
            Rectangle boundsA = this.getBoundsFor(this.selectorA.component());
            Rectangle boundsB = this.getBoundsFor(this.selectorB.component());
            switch (this.relativePosition) {
                case ABOVE: {
                    this.satisfied = boundsA.getMaxY() <= boundsB.getMinY();
                    break;
                }
                case BELOW: {
                    this.satisfied = boundsA.getMaxY() >= boundsB.getMaxY();
                    break;
                }
                case LEFTOF: {
                    this.satisfied = boundsA.getMaxX() <= boundsB.getMinX();
                    break;
                }
                case RIGHTOF: {
                    this.satisfied = boundsB.getMinX() >= boundsA.getMaxX();
                    break;
                }
                default: {
                    throw new Defect((Object)((Object)this.relativePosition) + " position not supported");
                }
            }
        }
    }

    @Override
    public boolean isSatisfied() {
        return this.satisfied;
    }

    private Rectangle getBoundsFor(Component component) {
        return new Rectangle(component.getLocationOnScreen(), component.getSize());
    }

    public void describeTo(Description description) {
        description.appendDescriptionOf(this.selectorA);
        description.appendText("\n");
        description.appendValue((Object)this.relativePosition);
        description.appendText("\n");
        description.appendDescriptionOf(this.selectorB);
    }

    @Override
    public boolean describeFailureTo(Description description) {
        description.appendText("was not in the expected relative position");
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RelativePosition {
        ABOVE,
        BELOW,
        LEFTOF,
        RIGHTOF;

    }
}

