/*
 * Decompiled with CFR 0.152.
 */
package com.objogate.wl.probe;

import com.objogate.wl.ComponentFinder;
import com.objogate.wl.internal.NoDuplicateList;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.MenuElement;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecursiveComponentFinder<T extends Component>
implements ComponentFinder<T> {
    private final ComponentFinder<? extends Component> parentOrOwnerFinder;
    private final Class<T> componentType;
    private final Matcher<? super T> criteria;
    private List<T> found = new NoDuplicateList();

    public RecursiveComponentFinder(Class<T> componentType, Matcher<? super T> criteria, ComponentFinder<? extends Component> parentOrOwnerFinder) {
        this.parentOrOwnerFinder = parentOrOwnerFinder;
        this.componentType = componentType;
        this.criteria = criteria;
    }

    @Override
    public boolean isSatisfied() {
        return this.parentOrOwnerFinder.isSatisfied();
    }

    @Override
    public List<T> components() {
        return this.found;
    }

    @Override
    public void probe() {
        this.parentOrOwnerFinder.probe();
        this.found.clear();
        this.searchWithin(this.parentOrOwnerFinder.components());
    }

    public void describeTo(Description description) {
        this.describeBrieflyTo(description);
        description.appendText("\n    in ").appendDescriptionOf(this.parentOrOwnerFinder);
    }

    @Override
    public boolean describeFailureTo(Description description) {
        if (this.parentOrOwnerFinder.describeFailureTo(description)) {
            return true;
        }
        description.appendText("\n    contained ").appendText(String.valueOf(this.found.size())).appendText(" ");
        this.describeBrieflyTo(description);
        return this.found.size() == 0;
    }

    private void searchWithin(Iterable<? extends Component> components) {
        for (Component component : components) {
            this.searchWithin(component);
        }
    }

    private void searchWithin(Component component) {
        if (this.componentType.isInstance(component) && this.criteria.matches((Object)component)) {
            this.found.add(this.componentType.cast(component));
        } else {
            if (component instanceof Container) {
                this.searchWithin(this.componentsInside((Container)component));
            }
            if (component instanceof Window) {
                this.searchWithin(this.windowsOwnedBy((Window)component));
            }
            if (component instanceof MenuElement) {
                this.searchWithin(this.componentsInMenu((MenuElement)((Object)component)));
            }
        }
    }

    private void describeBrieflyTo(Description description) {
        description.appendText(this.componentType.getSimpleName()).appendText(" ").appendDescriptionOf(this.criteria);
    }

    private List<Component> componentsInMenu(MenuElement menuElement) {
        ArrayList<Component> list = new ArrayList<Component>();
        for (MenuElement element : menuElement.getSubElements()) {
            list.add(element.getComponent());
        }
        return list;
    }

    private List<Window> windowsOwnedBy(Window window) {
        return Arrays.asList(window.getOwnedWindows());
    }

    private List<Component> componentsInside(Container container) {
        return Arrays.asList(container.getComponents());
    }
}

