/*
 * Decompiled with CFR 0.152.
 */
package com.objogate.wl.probe;

import com.objogate.wl.ComponentFinder;
import java.awt.Frame;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.hamcrest.Description;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopLevelWindowFinder
implements ComponentFinder<Window> {
    private List<Window> found = Collections.emptyList();

    @Override
    public boolean isSatisfied() {
        return true;
    }

    @Override
    public List<Window> components() {
        return this.found;
    }

    @Override
    public void probe() {
        HashSet<Window> topLevelWindows = new HashSet<Window>();
        for (Frame frame : Frame.getFrames()) {
            topLevelWindows.add(TopLevelWindowFinder.ownershipRoot(frame));
        }
        this.found = new ArrayList<Window>(topLevelWindows);
    }

    private static Window ownershipRoot(Window w) {
        return w.getOwner() == null ? w : TopLevelWindowFinder.ownershipRoot(w.getOwner());
    }

    public void describeTo(Description description) {
        description.appendText("all top level windows");
    }

    @Override
    public boolean describeFailureTo(Description description) {
        this.describeTo(description);
        return false;
    }
}

