/*
 * Decompiled with CFR 0.152.
 */
package com.objogate.wl.robot;

import com.objogate.exception.Defect;
import com.objogate.wl.keyboard.KeyboardLayout;
import com.objogate.wl.robot.Automaton;
import java.awt.AWTException;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Robot;

public class RoboticAutomaton
implements Automaton {
    private final Robot robot;
    private final KeyboardLayout keyboard;

    public RoboticAutomaton(Robot robot, KeyboardLayout keyboard) {
        this.robot = robot;
        this.keyboard = keyboard;
    }

    public RoboticAutomaton(KeyboardLayout keyboard) {
        this(RoboticAutomaton.createRobot(), keyboard);
    }

    public RoboticAutomaton() {
        this(RoboticAutomaton.createRobot(), KeyboardLayout.getDefaultKeyboardLayout());
    }

    private static Robot createRobot() {
        Robot robot;
        try {
            robot = new Robot();
        }
        catch (AWTException e) {
            throw new Defect("could not create AWT robot", e);
        }
        return robot;
    }

    public Point getPointerLocation() {
        return MouseInfo.getPointerInfo().getLocation();
    }

    public void mouseMove(int x, int y) {
        this.robot.mouseMove(x, y);
    }

    public void mousePress(int buttons) {
        this.robot.mousePress(buttons);
    }

    public void mouseRelease(int buttons) {
        this.robot.mouseRelease(buttons);
    }

    public void mouseWheel(int wheelAmt) {
        this.robot.mouseWheel(wheelAmt);
    }

    public void keyPress(int keycode) {
        this.robot.keyPress(keycode);
    }

    public void keyRelease(int keycode) {
        this.robot.keyRelease(keycode);
    }

    public void typeCharacter(char ch) {
        this.keyboard.gestureForTyping(ch).performGesture(this);
    }

    public void delay(int ms) {
        this.robot.delay(ms);
    }
}

