/*
 * Decompiled with CFR 0.152.
 */
package stopwatch.web;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.IntRef;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.NodeBuffer;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import stopwatch.web.HttpContext$;
import stopwatch.web.HttpResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HttpUtils$
implements ScalaObject {
    public static final HttpUtils$ MODULE$;
    private volatile Map<String, String> MIME_TYPES;

    static {
        new HttpUtils$();
    }

    public Map<String, String> MIME_TYPES() {
        return this.MIME_TYPES;
    }

    public void MIME_TYPES_$eq(Map<String, String> map) {
        this.MIME_TYPES = map;
    }

    public void sendError(int code, String message) {
        TopScope$ topScope$ = Predef$.MODULE$.$scope();
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n        "));
        TopScope$ topScope$2 = Predef$.MODULE$.$scope();
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n          "));
        TopScope$ topScope$3 = Predef$.MODULE$.$scope();
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)message);
        $buf2.$amp$plus((Object)new Elem(null, "p", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$3, (Seq)$buf3));
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf.$amp$plus((Object)new Elem(null, "body", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$2, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n      "));
        Elem msg = new Elem(null, "html", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$, (Seq)$buf);
        HttpContext$.MODULE$.response().status_$eq(code);
        HttpContext$.MODULE$.response().contentType_$eq("text/html");
        HttpContext$.MODULE$.response().content_$eq(msg.toString());
    }

    public void redirect(String location) {
        HttpContext$.MODULE$.log().info(new StringBuilder().append((Object)"Redirect: ").append((Object)location).toString());
        HttpResponse httpResponse = HttpContext$.MODULE$.response();
        httpResponse.headers_$eq((Map<String, String>)httpResponse.headers().$plus(Predef$.MODULE$.any2ArrowAssoc((Object)"Location").$minus$greater((Object)location)));
        HttpContext$.MODULE$.response().status_$eq(307);
    }

    public void seeOther(String location) {
        HttpContext$.MODULE$.log().info(new StringBuilder().append((Object)"See Other: ").append((Object)location).toString());
        HttpResponse httpResponse = HttpContext$.MODULE$.response();
        httpResponse.headers_$eq((Map<String, String>)httpResponse.headers().$plus(Predef$.MODULE$.any2ArrowAssoc((Object)"Location").$minus$greater((Object)location)));
        HttpContext$.MODULE$.response().status_$eq(303);
    }

    public String readLine(InputStream in) {
        byte[] buf$1 = new byte[4096];
        IntRef i$1 = new IntRef(0);
        while (i$1.elem < buf$1.length) {
            int x = in.read();
            if (x == -1 || x == 10) {
                return this.result$1(buf$1, i$1);
            }
            buf$1[i$1.elem] = (byte)x;
            ++i$1.elem;
        }
        return this.result$1(buf$1, i$1);
    }

    private String stripCRLF(String s) {
        return s.endsWith("\r") ? s.substring(0, s.length() - 1) : (s.endsWith("\r\n") ? s.substring(0, s.length() - 2) : (s.endsWith("\n") ? s.substring(0, s.length() - 1) : s));
    }

    public void serveClasspathResource(String path) {
        BufferedInputStream stream;
        Option<URL> resource = this.getResource(path);
        if (resource.isDefined()) {
            stream = new BufferedInputStream(((URL)resource.get()).openStream());
            String path2 = path;
            Map headers = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            if (path2.endsWith(".gz")) {
                path2 = path.substring(0, path2.length() - 3);
                headers = headers.$plus(Predef$.MODULE$.any2ArrowAssoc((Object)"Content-Encoding").$minus$greater((Object)"gzip"));
            }
            String ext = this.extension(path2);
            String contentType = (String)this.MIME_TYPES().get((Object)ext).getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return "application/octet-stream";
                }
            });
            headers = headers.$plus(Predef$.MODULE$.any2ArrowAssoc((Object)"Expires").$minus$greater((Object)"Thu, 01 Dec 2000 20:00:00 GMT"));
            HttpContext$.MODULE$.log().info(new StringBuilder().append((Object)"Serving: ").append((Object)path).append((Object)" (").append((Object)contentType).append((Object)")").toString());
            HttpContext$.MODULE$.response().status_$eq(200);
            HttpContext$.MODULE$.response().contentType_$eq(contentType);
            HttpResponse httpResponse = HttpContext$.MODULE$.response();
            httpResponse.headers_$eq((Map<String, String>)httpResponse.headers().$plus$plus((GenTraversableOnce)headers));
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            int bytesRead = stream.read(buffer);
            while (bytesRead >= 0) {
                out.write(buffer, 0, bytesRead);
                bytesRead = stream.read(buffer);
            }
            HttpContext$.MODULE$.response().content_$eq(out.toByteArray());
        } else {
            this.sendError(404, "Resource not found.");
        }
        return;
        finally {
            stream.close();
        }
    }

    public Option<URL> getResource(String path) {
        URL url = this.getClass().getClassLoader().getResource(path);
        return url != null ? new Some((Object)url) : None$.MODULE$;
    }

    public String extension(String s) {
        int slash;
        int dot = s.lastIndexOf(".");
        return dot > (slash = s.lastIndexOf("/")) ? s.substring(dot + 1, s.length()) : "";
    }

    public String urlEncode(String s) {
        return URLEncoder.encode(s, "UTF-8");
    }

    public String urlDecode(String s) {
        return URLDecoder.decode(s, "UTF-8");
    }

    public String id(String s) {
        return s.replaceAll("[^a-zA-Z0-9]", "-");
    }

    private final String result$1(byte[] byArray, IntRef intRef) {
        return this.stripCRLF(new String(byArray, 0, intRef.elem, "UTF-8"));
    }

    /*
     * WARNING - void declaration
     */
    private HttpUtils$() {
        void var1_1;
        MODULE$ = this;
        Map map = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        map = map.$plus(Predef$.MODULE$.any2ArrowAssoc((Object)"html").$minus$greater((Object)"text/html"));
        map = map.$plus(Predef$.MODULE$.any2ArrowAssoc((Object)"htm").$minus$greater((Object)"text/html"));
        map = map.$plus(Predef$.MODULE$.any2ArrowAssoc((Object)"css").$minus$greater((Object)"text/css"));
        map = map.$plus(Predef$.MODULE$.any2ArrowAssoc((Object)"gz").$minus$greater((Object)"application/x-gzip"));
        map = map.$plus(Predef$.MODULE$.any2ArrowAssoc((Object)"js").$minus$greater((Object)"tesxt/javascript"));
        map = map.$plus(Predef$.MODULE$.any2ArrowAssoc((Object)"gif").$minus$greater((Object)"image/gif"));
        map = map.$plus(Predef$.MODULE$.any2ArrowAssoc((Object)"jpeg").$minus$greater((Object)"image/jpeg"));
        map = map.$plus(Predef$.MODULE$.any2ArrowAssoc((Object)"jpeg").$minus$greater((Object)"image/jpeg"));
        map = map.$plus(Predef$.MODULE$.any2ArrowAssoc((Object)"png").$minus$greater((Object)"image/png"));
        map = map.$plus(Predef$.MODULE$.any2ArrowAssoc((Object)"txt").$minus$greater((Object)"txt/plain"));
        this.MIME_TYPES = var1_1;
    }
}

