/*
 * Decompiled with CFR 0.152.
 */
package stopwatch.web;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import scala.Function0;
import scala.ScalaObject;
import scala.StringBuilder;
import scala.runtime.BoxesRunTime;
import stopwatch.web.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleLogger
implements Logger,
ScalaObject {
    private volatile DateFormat dateFormat;
    private volatile String logPrefix;
    private volatile boolean logDateTime;
    private volatile boolean logError;
    private volatile boolean logWarn;
    private volatile boolean logInfo;
    private volatile boolean logDebug;
    private final Writer writer;

    public SimpleLogger(Writer writer) {
        this.writer = writer;
        this.logDebug = false;
        this.logInfo = true;
        this.logWarn = true;
        this.logError = true;
        this.logDateTime = true;
        this.logPrefix = "";
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS z");
    }

    public void log(String s) {
        if (this.logDateTime()) {
            long now = System.currentTimeMillis();
            String formatted = ((DateFormat)this.dateFormat().clone()).format(BoxesRunTime.boxToLong((long)now));
            this.writer().write(formatted);
            this.writer().write(" ");
        }
        if (this.logPrefix().length() > 0) {
            this.writer().write(this.logPrefix());
            this.writer().write(" ");
        }
        this.writer().write(s);
        this.writer().write("\n");
        this.writer().flush();
    }

    @Override
    public void error(String s) {
        if (this.logError()) {
            this.log(new StringBuilder().append((Object)"ERROR: ").append((Object)s).toString());
        }
    }

    @Override
    public void warn(String s) {
        if (this.logWarn()) {
            this.log(new StringBuilder().append((Object)" WARN: ").append((Object)s).toString());
        }
    }

    @Override
    public void info(String s) {
        if (this.logInfo()) {
            this.log(new StringBuilder().append((Object)" INFO: ").append((Object)s).toString());
        }
    }

    @Override
    public void debug(Function0<String> s) {
        if (this.logDebug()) {
            this.log(new StringBuilder().append((Object)"DEBUG: ").append(s.apply()).toString());
        }
    }

    public SimpleLogger() {
        this(System.out);
    }

    public SimpleLogger(OutputStream out) {
        this(new OutputStreamWriter(out));
    }

    public void dateFormat_$eq(DateFormat x$1) {
        this.dateFormat = x$1;
    }

    public DateFormat dateFormat() {
        return this.dateFormat;
    }

    public void logPrefix_$eq(String x$1) {
        this.logPrefix = x$1;
    }

    public String logPrefix() {
        return this.logPrefix;
    }

    public void logDateTime_$eq(boolean x$1) {
        this.logDateTime = x$1;
    }

    public boolean logDateTime() {
        return this.logDateTime;
    }

    public void logError_$eq(boolean x$1) {
        this.logError = x$1;
    }

    public boolean logError() {
        return this.logError;
    }

    public void logWarn_$eq(boolean x$1) {
        this.logWarn = x$1;
    }

    public boolean logWarn() {
        return this.logWarn;
    }

    public void logInfo_$eq(boolean x$1) {
        this.logInfo = x$1;
    }

    public boolean logInfo() {
        return this.logInfo;
    }

    public void logDebug_$eq(boolean x$1) {
        this.logDebug = x$1;
    }

    public boolean logDebug() {
        return this.logDebug;
    }

    public Writer writer() {
        return this.writer;
    }

    public int $tag() throws RemoteException {
        return ScalaObject.class.$tag((ScalaObject)this);
    }
}

