/*
 * Decompiled with CFR 0.152.
 */
package stopwatch.web;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.RemoteException;
import java.util.concurrent.Executor;
import scala.;
import scala.Function0;
import scala.Function1;
import scala.List;
import scala.MatchError;
import scala.Nil$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Seq;
import scala.Some;
import scala.StringBuilder;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.runtime.BoxedObjectArray;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.matching.Regex;
import stopwatch.StopwatchGroup;
import stopwatch.web.HttpContext$;
import stopwatch.web.HttpRequest;
import stopwatch.web.HttpResponse;
import stopwatch.web.HttpUtils$;
import stopwatch.web.Logger;
import stopwatch.web.NoLogger$;
import stopwatch.web.ResourceHandler;
import stopwatch.web.WebServer$;
import stopwatch.web.WebServer$$anonfun$stopwatch$web$WebServer$;
import stopwatch.web.WebServer$SameThreadExecutor$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServer
implements ScalaObject {
    private /* synthetic */ WebServer$SameThreadExecutor$ SameThreadExecutor$module;
    private final StopwatchGroup stopwatch;
    private volatile Executor executor;
    private volatile boolean productionMode = true;
    private volatile boolean debugLogging = false;
    private volatile Logger log;
    private final Regex postRegex;
    private final Regex getRegex;
    private volatile List<ResourceHandler> handlers;
    private volatile int port = 9999;
    private volatile Option stopwatch$web$WebServer$$_serverSocket;
    private volatile boolean _running = false;
    private volatile Option<Thread> _thread = None$.MODULE$;

    public WebServer() {
        this.stopwatch$web$WebServer$$_serverSocket = None$.MODULE$;
        this.handlers = Nil$.MODULE$;
        this.getRegex = Predef$.MODULE$.stringWrapper("GET\\s+(\\S+)\\s*(\\sHTTP/1\\.[01])?\\s*").r();
        this.postRegex = Predef$.MODULE$.stringWrapper("POST\\s+(\\S+)\\s*(\\sHTTP/1\\.[01])?\\s*").r();
        this.log = NoLogger$.MODULE$;
        this.executor = this.SameThreadExecutor();
        this.stopwatch = new StopwatchGroup(this.getClass().getName());
    }

    public final void writeLine$1(String s$1, OutputStream outputStream) {
        this.log().debug(new $anonfun$writeLine$1$1(this, s$1));
        outputStream.write(s$1.getBytes("UTF-8"));
        outputStream.write(13);
        outputStream.write(10);
    }

    public final WebServer$SameThreadExecutor$ SameThreadExecutor() {
        if (this.SameThreadExecutor$module == null) {
            this.SameThreadExecutor$module = new WebServer$SameThreadExecutor$(this);
        }
        return this.SameThreadExecutor$module;
    }

    public final String stopwatch$web$WebServer$$extension(String s) {
        int slash;
        int dot = s.lastIndexOf(".");
        return dot > (slash = s.lastIndexOf("/")) ? s.substring(dot, s.length()) : "";
    }

    public Tuple2<HttpRequest, HttpResponse> parseRequest(InputStream in) {
        ObjectRef req$1;
        block12: {
            block16: {
                Tuple2 tuple2;
                String requestMethod$1;
                block18: {
                    Tuple2 tuple22;
                    List list;
                    String string;
                    block17: {
                        Tuple2 tuple23;
                        block15: {
                            String path;
                            Tuple2 tuple24;
                            block13: {
                                List list2;
                                String string2;
                                block14: {
                                    Option option;
                                    block11: {
                                        List list3;
                                        req$1 = new ObjectRef((Object)HttpUtils$.MODULE$.readLine(in));
                                        this.log().debug(new $anonfun$parseRequest$1(this, req$1));
                                        string2 = (String)req$1.elem;
                                        option = this.getRegex().unapplySeq((Object)string2);
                                        if (!option.isEmpty()) break block11;
                                        Option option2 = this.postRegex().unapplySeq((Object)string2);
                                        if (option2.isEmpty() || (list3 = (List)option2.get()).lengthCompare(2) != 0) break block12;
                                        String string3 = (String)list3.apply(0);
                                        String string4 = (String)list3.apply(1);
                                        break block13;
                                    }
                                    List list4 = (List)option.get();
                                    if (list4.lengthCompare(2) != 0) break block14;
                                    tuple24 = new Tuple2((Object)"GET", list4.apply(0));
                                    break block15;
                                }
                                Option option = this.postRegex().unapplySeq((Object)string2);
                                if (option.isEmpty() || (list2 = (List)option.get()).lengthCompare(2) != 0) break block12;
                                String string5 = (String)list2.apply(0);
                                String string6 = (String)list2.apply(1);
                                path = string5;
                                String httpVersion = string6;
                            }
                            tuple24 = tuple23 = new Tuple2((Object)"POST", (Object)path);
                        }
                        if (tuple23 == null) {
                            throw new MatchError((Object)tuple23);
                        }
                        Tuple2 tuple25 = new Tuple2(tuple23._1(), tuple23._2());
                        requestMethod$1 = (String)tuple25._1();
                        String path = (String)tuple25._2();
                        List list5 = new BoxedObjectArray((Object[])path.split("\\?")).toList();
                        if (!(list5 instanceof .colon.colon)) break block16;
                        .colon.colon colon2 = (.colon.colon)list5;
                        string = (String)colon2.hd$1();
                        list = colon2.tl$1();
                        Nil$ nil$ = Nil$.MODULE$;
                        List list6 = list;
                        if (nil$ != null ? !nil$.equals(list6) : list6 != null) break block17;
                        tuple22 = new Tuple2((Object)string, (Object)"");
                        break block18;
                    }
                    if (!(list instanceof .colon.colon)) break block16;
                    .colon.colon colon3 = (.colon.colon)list;
                    String string7 = (String)colon3.hd$1();
                    Nil$ nil$ = Nil$.MODULE$;
                    List list7 = colon3.tl$1();
                    if (nil$ != null ? !nil$.equals(list7) : list7 != null) break block16;
                    tuple22 = tuple2 = new Tuple2((Object)string, (Object)string7);
                }
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Tuple2 tuple26 = new Tuple2(tuple2._1(), tuple2._2());
                String path2 = (String)tuple26._1();
                String query = (String)tuple26._2();
                List path3$1 = new BoxedObjectArray((Object[])path2.split("/")).toList().filter((Function1)new $anonfun$1(this)).map((Function1)new $anonfun$2(this)).map((Function1)new $anonfun$3(this));
                if (path3$1.exists((Function1)new $anonfun$parseRequest$2(this))) {
                    throw Predef$.MODULE$.error(new StringBuilder().append((Object)"Request path should not contain '..': ").append((Object)((String)req$1.elem)).toString());
                }
                this.log().debug(new $anonfun$parseRequest$3(this, path3$1));
                String ext$1 = (String)path3$1.lastOption().map((Function1)new $anonfun$4(this)).getOrElse((Function0)new $anonfun$5(this));
                ObjectRef map$1 = new ObjectRef((Object)Predef$.MODULE$.Map().apply((Seq)new BoxedObjectArray((Object[])new Tuple2[0])));
                List list = new BoxedObjectArray((Object[])query.split("&")).toList().filter((Function1)new $anonfun$6(this));
                list.foreach((Function1)new $anonfun$7(this, map$1));
                Map params$1 = (Map)map$1.elem;
                Map headers = Predef$.MODULE$.Map().apply((Seq)new BoxedObjectArray((Object[])new Tuple2[0]));
                String line = HttpUtils$.MODULE$.readLine(in);
                while (true) {
                    block20: {
                        block19: {
                            String string;
                            if ((string = line) == null || string.equals(null)) break block19;
                            String string8 = line.trim();
                            String string9 = "";
                            if (string8 != null ? !string8.equals(string9) : string9 != null) break block20;
                        }
                        Map requestHeaders$1 = headers;
                        ObjectRef fields$1 = new ObjectRef((Object)Nil$.MODULE$);
                        String string = requestMethod$1;
                        String string10 = "POST";
                        if (!(string != null ? !string.equals(string10) : string10 != null)) {
                            String string11;
                            int n;
                            int contentLength2 = BoxesRunTime.unboxToInt((Object)requestHeaders$1.get((Object)"Content-Length").map((Function1)new $anonfun$8(this)).getOrElse((Function0)new $anonfun$9(this)));
                            byte[] buf = new byte[contentLength2];
                            for (int read = 0; read < contentLength2; read += n) {
                                n = in.read(buf, read, contentLength2 - read);
                            }
                            ByteArrayInputStream in2$1 = new ByteArrayInputStream(buf);
                            ObjectRef line$1 = new ObjectRef((Object)HttpUtils$.MODULE$.readLine(in2$1));
                            while ((string11 = (String)line$1.elem) != null && !string11.equals(null) && ((String)line$1.elem).trim().length() > 0) {
                                this.log().debug(new $anonfun$parseRequest$4(this, line$1));
                                new BoxedObjectArray((Object[])((String)line$1.elem).split("&")).foreach((Function1)new $anonfun$parseRequest$5(this, fields$1, in2$1, line$1));
                            }
                            this.log().debug(new $anonfun$parseRequest$6(this, fields$1));
                        }
                        $anon$5 request = new $anon$5(this, requestMethod$1, path3$1, ext$1, params$1, requestHeaders$1, fields$1);
                        $anon$2 response = new $anon$2(this);
                        return new Tuple2((Object)request, (Object)response);
                    }
                    int pos = line.indexOf(": ");
                    if (pos > 0) {
                        String header = line.substring(0, pos);
                        String value = line.substring(pos + 2, line.length());
                        headers = headers.$plus(Predef$.MODULE$.any2ArrowAssoc((Object)header).$minus$greater((Object)value));
                        line = HttpUtils$.MODULE$.readLine(in);
                        continue;
                    }
                    line = null;
                }
            }
            throw Predef$.MODULE$.error(new StringBuilder().append((Object)"Illegal request path: ").append((Object)((String)req$1.elem)).toString());
        }
        throw Predef$.MODULE$.error(new StringBuilder().append((Object)"Illegal or unsupported request: ").append((Object)((String)req$1.elem)).toString());
    }

    public final void stopwatch$web$WebServer$$send(HttpResponse response, OutputStream out$2) {
        this.writeLine$1(new StringBuilder().append((Object)"HTTP/1.0 ").append((Object)BoxesRunTime.boxToInteger((int)response.status())).append((Object)"").toString(), out$2);
        this.writeLine$1("Server: stopwatch.web.WebServer/1.0", out$2);
        response.headers().foreach((Function1)new $anonfun$stopwatch$web$WebServer$$send$1(this, out$2));
        response.contentLength().foreach((Function1)new $anonfun$stopwatch$web$WebServer$$send$2(this, out$2));
        this.writeLine$1("", out$2);
        response.content().foreach((Function1)new $anonfun$stopwatch$web$WebServer$$send$3(this, out$2));
        out$2.flush();
    }

    private void ignore(Function0<Object> f) {
        try {
            f.apply();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public final void stopwatch$web$WebServer$$handleRequest(Socket socket) {
        BufferedInputStream in$1 = new BufferedInputStream(socket.getInputStream());
        BufferedOutputStream out$1 = new BufferedOutputStream(socket.getOutputStream());
        try {
            try {
                Tuple2<HttpRequest, HttpResponse> tuple2 = this.parseRequest(in$1);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
                HttpRequest request$1 = (HttpRequest)tuple22._1();
                HttpResponse response$1 = (HttpResponse)tuple22._2();
                HttpContext$.MODULE$._log().set(this.log());
                HttpContext$.MODULE$._request().set(request$1);
                HttpContext$.MODULE$._response().set(response$1);
                this.stopwatch().apply(request$1.path().mkString("/"), (Function0)new $anonfun$stopwatch$web$WebServer$$handleRequest$1(this, out$1, request$1, response$1));
                this.ignore(new $anonfun$stopwatch$web$WebServer$$handleRequest$2(this, out$1));
                this.ignore(new $anonfun$stopwatch$web$WebServer$$handleRequest$3(this, in$1));
                this.ignore(new $anonfun$stopwatch$web$WebServer$$handleRequest$4(this, out$1));
            }
            catch (Throwable throwable) {
                this.log().error(throwable.getMessage());
                if (!this.productionMode()) {
                    throwable.printStackTrace();
                }
                $anon$1 response = new $anon$1(this);
                this.stopwatch$web$WebServer$$send(response, out$1);
                this.ignore(new $anonfun$stopwatch$web$WebServer$$handleRequest$2(this, out$1));
                this.ignore(new $anonfun$stopwatch$web$WebServer$$handleRequest$3(this, in$1));
                this.ignore(new $anonfun$stopwatch$web$WebServer$$handleRequest$4(this, out$1));
            }
            return;
        }
        catch (Throwable throwable) {
            this.ignore(new $anonfun$stopwatch$web$WebServer$$handleRequest$2(this, out$1));
            this.ignore(new $anonfun$stopwatch$web$WebServer$$handleRequest$3(this, in$1));
            this.ignore(new $anonfun$stopwatch$web$WebServer$$handleRequest$4(this, out$1));
            throw throwable;
        }
    }

    public void stop() {
        this._running_$eq(false);
        this._thread().foreach((Function1)new $anonfun$stop$1(this));
    }

    public void start() {
        if (this._running()) {
            throw new IllegalStateException("Server is already running.");
        }
        this._running_$eq(true);
        $anon$3 serverLoop = new $anon$3(this);
        this.stopwatch$web$WebServer$$_serverSocket_$eq((Option)new Some((Object)new ServerSocket(this.port())));
        Thread t = new Thread((Runnable)serverLoop, this.getClass().getName());
        t.setDaemon(true);
        t.start();
        this._thread_$eq((Option<Thread>)new Some((Object)t));
    }

    public StopwatchGroup stopwatch() {
        return this.stopwatch;
    }

    public void executor_$eq(Executor x$1) {
        this.executor = x$1;
    }

    public Executor executor() {
        return this.executor;
    }

    public void productionMode_$eq(boolean x$1) {
        this.productionMode = x$1;
    }

    public boolean productionMode() {
        return this.productionMode;
    }

    public void debugLogging_$eq(boolean x$1) {
        this.debugLogging = x$1;
    }

    public boolean debugLogging() {
        return this.debugLogging;
    }

    public void log_$eq(Logger x$1) {
        this.log = x$1;
    }

    public Logger log() {
        return this.log;
    }

    public Regex postRegex() {
        return this.postRegex;
    }

    public Regex getRegex() {
        return this.getRegex;
    }

    public void handlers_$eq(List<ResourceHandler> x$1) {
        this.handlers = x$1;
    }

    public List<ResourceHandler> handlers() {
        return this.handlers;
    }

    public void port_$eq(int x$1) {
        this.port = x$1;
    }

    public int port() {
        return this.port;
    }

    private void stopwatch$web$WebServer$$_serverSocket_$eq(Option x$1) {
        this.stopwatch$web$WebServer$$_serverSocket = x$1;
    }

    public final Option stopwatch$web$WebServer$$_serverSocket() {
        return this.stopwatch$web$WebServer$$_serverSocket;
    }

    public void _running_$eq(boolean x$1) {
        this._running = x$1;
    }

    public boolean _running() {
        return this._running;
    }

    private void _thread_$eq(Option<Thread> x$1) {
        this._thread = x$1;
    }

    private Option<Thread> _thread() {
        return this._thread;
    }

    public int $tag() throws RemoteException {
        return ScalaObject.class.$tag((ScalaObject)this);
    }
}

