/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.junit.runtime;

import junit.framework.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPlatformRunnable;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.pde.internal.junit.runtime.RemotePluginTestRunner;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.testing.ITestHarness;
import org.eclipse.ui.testing.TestableObject;

public class UITestApplication
implements IApplication,
ITestHarness {
    private static final String DEFAULT_APP_3_0 = "org.eclipse.ui.ide.workbench";
    private TestableObject fTestableObject;
    private IApplication fApplication;

    public Object start(IApplicationContext context) throws Exception {
        String[] args = (String[])context.getArguments().get("application.args");
        Object app = this.getApplication(args);
        Assert.assertNotNull((Object)app);
        this.fTestableObject = PlatformUI.getTestableObject();
        this.fTestableObject.setTestHarness((ITestHarness)this);
        if (app instanceof IApplication) {
            this.fApplication = (IApplication)app;
            return this.fApplication.start(context);
        }
        return ((IPlatformRunnable)app).run((Object)args);
    }

    public void stop() {
        if (this.fApplication != null) {
            this.fApplication.stop();
        }
    }

    private Object getApplication(String[] args) throws CoreException {
        Object runnable;
        IConfigurationElement[] runs;
        IExtension extension = Platform.getExtensionRegistry().getExtension("org.eclipse.core.runtime", "applications", this.getApplicationToRun(args));
        Assert.assertNotNull((Object)extension);
        IConfigurationElement[] elements = extension.getConfigurationElements();
        if (elements.length > 0 && (runs = elements[0].getChildren("run")).length > 0 && ((runnable = runs[0].createExecutableExtension("class")) instanceof IPlatformRunnable || runnable instanceof IApplication)) {
            return runnable;
        }
        return null;
    }

    private String getApplicationToRun(String[] args) {
        IProduct product = Platform.getProduct();
        if (product != null) {
            return product.getApplication();
        }
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-testApplication") && i < args.length - 1) {
                return args[i + 1];
            }
            ++i;
        }
        return DEFAULT_APP_3_0;
    }

    public void runTests() {
        this.fTestableObject.testingStarting();
        this.fTestableObject.runTest(new Runnable(){

            public void run() {
                RemotePluginTestRunner.main(Platform.getCommandLineArgs());
            }
        });
        this.fTestableObject.testingFinished();
    }
}

