/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.runtime.logview;

import com.ibm.icu.text.SimpleDateFormat;
import java.util.ArrayList;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.pde.internal.runtime.PDERuntimeMessages;
import org.eclipse.pde.internal.runtime.PDERuntimePluginImages;
import org.eclipse.pde.internal.runtime.logview.LogEntry;
import org.eclipse.swt.graphics.Image;

public class LogViewLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private static int MAX_LABEL_LENGTH = 200;
    private Image infoImage;
    private Image okImage;
    private Image errorImage;
    private Image warningImage;
    private Image errorWithStackImage;
    ArrayList consumers = new ArrayList();

    public LogViewLabelProvider() {
        this.errorImage = PDERuntimePluginImages.DESC_ERROR_ST_OBJ.createImage();
        this.warningImage = PDERuntimePluginImages.DESC_WARNING_ST_OBJ.createImage();
        this.infoImage = PDERuntimePluginImages.DESC_INFO_ST_OBJ.createImage();
        this.okImage = PDERuntimePluginImages.DESC_OK_ST_OBJ.createImage();
        this.errorWithStackImage = PDERuntimePluginImages.DESC_ERROR_STACK_OBJ.createImage();
    }

    public void dispose() {
        if (this.consumers.size() == 0) {
            this.errorImage.dispose();
            this.infoImage.dispose();
            this.okImage.dispose();
            this.warningImage.dispose();
            this.errorWithStackImage.dispose();
            super.dispose();
        }
    }

    public Image getColumnImage(Object element, int columnIndex) {
        LogEntry entry = (LogEntry)((Object)element);
        if (columnIndex == 0) {
            switch (entry.getSeverity()) {
                case 1: {
                    return this.infoImage;
                }
                case 0: {
                    return this.okImage;
                }
                case 2: {
                    return this.warningImage;
                }
            }
            return entry.getStack() == null ? this.errorImage : this.errorWithStackImage;
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        LogEntry entry = (LogEntry)((Object)element);
        switch (columnIndex) {
            case 0: {
                if (entry.getMessage() != null) {
                    String message = entry.getMessage();
                    if (message.length() > MAX_LABEL_LENGTH) {
                        String warning = PDERuntimeMessages.LogViewLabelProvider_truncatedMessage;
                        StringBuffer sb = new StringBuffer(message.substring(0, MAX_LABEL_LENGTH - warning.length()));
                        sb.append(warning);
                        return sb.toString();
                    }
                    return entry.getMessage();
                }
            }
            case 1: {
                if (entry.getPluginId() != null) {
                    return entry.getPluginId();
                }
            }
            case 2: {
                if (entry.getDate() == null) break;
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                return formatter.format(entry.getDate());
            }
        }
        return "";
    }

    public void connect(Object consumer) {
        if (!this.consumers.contains(consumer)) {
            this.consumers.add(consumer);
        }
    }

    public void disconnect(Object consumer) {
        this.consumers.remove(consumer);
        if (this.consumers.size() == 0) {
            this.dispose();
        }
    }
}

