/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ui.PixelConverter;
import org.eclipse.team.internal.ui.SWTUtils;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class CVSPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private final String[] KSUBST_VALUES;
    private final String[] KSUBST_LABELS;
    private final String[] COMPRESSION_LABELS;
    private final Integer[] COMPRESSION_VALUES;
    protected final ArrayList fFields = new ArrayList();
    private final String[] PERSPECTIVE_VALUES;
    private final String[] PERSPECTIVE_LABELS;
    private final String[] YES_NO_PROMPT;

    public CVSPreferencesPage() {
        Command.KSubstOption[] options = Command.KSubstOption.getAllKSubstOptions();
        ArrayList<Command.KSubstOption> KSUBST_MODES = new ArrayList<Command.KSubstOption>();
        int i = 0;
        while (i < options.length) {
            Command.KSubstOption option = options[i];
            if (!option.isBinary()) {
                KSUBST_MODES.add(option);
            }
            ++i;
        }
        Collections.sort(KSUBST_MODES, new Comparator(){

            public int compare(Object a, Object b) {
                String aKey = ((Command.KSubstOption)a).getLongDisplayText();
                String bKey = ((Command.KSubstOption)b).getLongDisplayText();
                return aKey.compareTo(bKey);
            }
        });
        this.KSUBST_LABELS = new String[KSUBST_MODES.size()];
        this.KSUBST_VALUES = new String[KSUBST_MODES.size()];
        int index = 0;
        Iterator iter = KSUBST_MODES.iterator();
        while (iter.hasNext()) {
            Command.KSubstOption mod = (Command.KSubstOption)iter.next();
            this.KSUBST_LABELS[index] = mod.getLongDisplayText();
            String mode = mod.toMode().trim();
            this.KSUBST_VALUES[index] = mode.length() != 0 ? mode : "-kkv";
            ++index;
        }
        this.COMPRESSION_LABELS = new String[]{CVSUIMessages.CVSPreferencesPage_0, CVSUIMessages.CVSPreferencesPage_1, CVSUIMessages.CVSPreferencesPage_2, CVSUIMessages.CVSPreferencesPage_3, CVSUIMessages.CVSPreferencesPage_4, CVSUIMessages.CVSPreferencesPage_5};
        this.COMPRESSION_VALUES = new Integer[this.COMPRESSION_LABELS.length];
        int i2 = 0;
        while (i2 < this.COMPRESSION_VALUES.length) {
            this.COMPRESSION_VALUES[i2] = new Integer(i2);
            ++i2;
        }
        IPerspectiveDescriptor[] perspectives = PlatformUI.getWorkbench().getPerspectiveRegistry().getPerspectives();
        this.PERSPECTIVE_VALUES = new String[perspectives.length + 1];
        this.PERSPECTIVE_LABELS = new String[perspectives.length + 1];
        Arrays.sort(perspectives, new PerspectiveDescriptorComparator());
        this.PERSPECTIVE_VALUES[0] = "none";
        this.PERSPECTIVE_LABELS[0] = CVSUIMessages.CVSPreferencesPage_10;
        int i3 = 0;
        while (i3 < perspectives.length) {
            this.PERSPECTIVE_VALUES[i3 + 1] = perspectives[i3].getId();
            this.PERSPECTIVE_LABELS[i3 + 1] = perspectives[i3].getLabel();
            ++i3;
        }
        this.YES_NO_PROMPT = new String[]{CVSUIMessages.CVSPreferencesPage_11, CVSUIMessages.CVSPreferencesPage_12, CVSUIMessages.CVSPreferencesPage_13};
        IPreferenceStore store = CVSUIPlugin.getPlugin().getPreferenceStore();
        String id = store.getString("pref_default_perspective_for_show_annotations");
        if (PlatformUI.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId(id) == null) {
            store.putValue("pref_default_perspective_for_show_annotations", "none");
        }
    }

    protected Control createContents(Composite parent) {
        TabFolder tabFolder = new TabFolder(parent, 0);
        tabFolder.setLayoutData((Object)SWTUtils.createHFillGridData());
        this.createGeneralTab(tabFolder);
        this.createFilesFoldersTab(tabFolder);
        this.createConnectionTab(tabFolder);
        this.createPromptingTab(tabFolder);
        this.initializeValues();
        Dialog.applyDialogFont((Control)parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.team.cvs.ui.general_preference_page_context");
        return tabFolder;
    }

    private Composite createGeneralTab(TabFolder tabFolder) {
        Composite composite = SWTUtils.createHFillComposite((Composite)tabFolder, (int)-1);
        TabItem tab = new TabItem(tabFolder, 0);
        tab.setText(CVSUIMessages.CVSPreferencesPage_14);
        tab.setControl((Control)composite);
        new Checkbox(composite, "pref_determine_server_version", CVSUIMessages.CVSPreferencesPage_15, "org.eclipse.team.cvs.ui.determine_server_version");
        new Checkbox(composite, "pref_confirm_move_tag", CVSUIMessages.CVSPreferencesPage_16, "org.eclipse.team.cvs.ui.confirm_move_tag");
        new Checkbox(composite, "pref_debug_protocol", CVSUIMessages.CVSPreferencesPage_17, "org.eclipse.team.cvs.ui.debug_protocol_pref");
        new Checkbox(composite, "pref_auto_refresh_tags_in_tag_selection_dialog", CVSUIMessages.CVSPreferencesPage_18, "org.eclipse.team.cvs.ui.auto_refresh_tag");
        new Checkbox(composite, "pref_auto_share_on_import", CVSUIMessages.CVSPreferencesPage_44, null);
        new Checkbox(composite, "pref_use_project_name_on_checkout", CVSUIMessages.CVSPreferencesPage_45, null);
        Composite textComposite = SWTUtils.createHFillComposite((Composite)composite, (int)0, (int)2);
        new TextField(textComposite, "pref_commit_files_display_threshold", CVSUIMessages.CVSPreferencesPage_20, null){

            protected void modifyText(Text text) {
                try {
                    int x = Integer.parseInt(text.getText());
                    if (x >= 0) {
                        CVSPreferencesPage.this.setErrorMessage(null);
                        CVSPreferencesPage.this.setValid(true);
                    } else {
                        CVSPreferencesPage.this.setErrorMessage(CVSUIMessages.CVSPreferencesPage_21);
                        CVSPreferencesPage.this.setValid(false);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    CVSPreferencesPage.this.setErrorMessage(CVSUIMessages.CVSPreferencesPage_22);
                    CVSPreferencesPage.this.setValid(false);
                }
            }
        };
        new TextField(textComposite, "pref_commit_comments_max_history", CVSUIMessages.CVSPreferencesPage_47, null){

            protected void modifyText(Text text) {
                try {
                    int x = Integer.parseInt(text.getText());
                    if (x > 0) {
                        CVSPreferencesPage.this.setErrorMessage(null);
                        CVSPreferencesPage.this.setValid(true);
                    } else {
                        CVSPreferencesPage.this.setErrorMessage(CVSUIMessages.CVSPreferencesPage_48);
                        CVSPreferencesPage.this.setValid(false);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    CVSPreferencesPage.this.setErrorMessage(CVSUIMessages.CVSPreferencesPage_49);
                    CVSPreferencesPage.this.setValid(false);
                }
            }
        };
        return composite;
    }

    private Composite createConnectionTab(TabFolder tabFolder) {
        Composite composite = SWTUtils.createHFillComposite((Composite)tabFolder, (int)-1);
        TabItem tab = new TabItem(tabFolder, 0);
        tab.setText(CVSUIMessages.CVSPreferencesPage_19);
        tab.setControl((Control)composite);
        Composite textComposite = SWTUtils.createHFillComposite((Composite)composite, (int)0, (int)2);
        new TextField(textComposite, "pref_timeout", CVSUIMessages.CVSPreferencesPage_23, "org.eclipse.team.cvs.ui.comms_timeout_pref"){

            protected void modifyText(Text text) {
                try {
                    int x = Integer.parseInt(text.getText());
                    if (x >= 0) {
                        CVSPreferencesPage.this.setErrorMessage(null);
                        CVSPreferencesPage.this.setValid(true);
                    } else {
                        CVSPreferencesPage.this.setErrorMessage(CVSUIMessages.CVSPreferencesPage_24);
                        CVSPreferencesPage.this.setValid(false);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    CVSPreferencesPage.this.setErrorMessage(CVSUIMessages.CVSPreferencesPage_25);
                    CVSPreferencesPage.this.setValid(false);
                }
            }
        };
        final IntegerComboBox quietnessCombo = new IntegerComboBox(textComposite, "pref_quietness", CVSUIMessages.CVSPreferencesPage_26, "org.eclipse.team.cvs.ui.quietness_level_pref", new String[]{CVSUIMessages.CVSPreferencesPage_27, CVSUIMessages.CVSPreferencesPage_28, CVSUIMessages.CVSPreferencesPage_29}, new Integer[]{new Integer(0), new Integer(1), new Integer(2)});
        quietnessCombo.getCombo().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (CVSPreferencesPage.getQuietnessOptionFor(quietnessCombo.getCombo().getSelectionIndex()).equals((Object)Command.SILENT)) {
                    MessageDialog.openWarning((Shell)CVSPreferencesPage.this.getShell(), (String)CVSUIMessages.CVSPreferencesPage_30, (String)CVSUIMessages.CVSPreferencesPage_31);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        new IntegerComboBox(textComposite, "pref_compression_level", CVSUIMessages.CVSPreferencesPage_32, "org.eclipse.team.cvs.ui.compression_level_pref", this.COMPRESSION_LABELS, this.COMPRESSION_VALUES);
        SWTUtils.createPreferenceLink((IWorkbenchPreferenceContainer)((IWorkbenchPreferenceContainer)this.getContainer()), (Composite)composite, (String)CVSUIMessages.CVSPreferencesPage_52, (String)CVSUIMessages.CVSPreferencesPage_53);
        SWTUtils.createPreferenceLink((IWorkbenchPreferenceContainer)((IWorkbenchPreferenceContainer)this.getContainer()), (Composite)composite, (String)CVSUIMessages.CVSPreferencesPage_54, (String)CVSUIMessages.CVSPreferencesPage_55);
        return composite;
    }

    private Composite createFilesFoldersTab(TabFolder tabFolder) {
        Composite composite = SWTUtils.createHFillComposite((Composite)tabFolder, (int)-1);
        TabItem tab = new TabItem(tabFolder, 0);
        tab.setText(CVSUIMessages.CVSPreferencesPage_33);
        tab.setControl((Control)composite);
        new Checkbox(composite, "pref_repositories_are_binary", CVSUIMessages.CVSPreferencesPage_34, "org.eclipse.team.cvs.ui.treat_new_files_as_binary_pref");
        new Checkbox(composite, "pref_lineend", CVSUIMessages.CVSPreferencesPage_35, "org.eclipse.team.cvs.ui.line_end_pref");
        new Checkbox(composite, "pref_prune_empty_directories", CVSUIMessages.CVSPreferencesPage_36, "org.eclipse.team.cvs.ui.prune_empty_directories_pref");
        new Checkbox(composite, "pref_replace_unmanaged", CVSUIMessages.CVSPreferencesPage_37, "org.eclipse.team.cvs.ui.replace_deletion_of_unmanaged_pref");
        SWTUtils.createPlaceholder((Composite)composite, (int)1);
        Composite bottom = SWTUtils.createHFillComposite((Composite)composite, (int)0, (int)2);
        new StringComboBox(bottom, "pref_text_ksubst", CVSUIMessages.CVSPreferencesPage_38, "org.eclipse.team.cvs.ui.default_keywordmode_pref", this.KSUBST_LABELS, this.KSUBST_VALUES);
        return composite;
    }

    private Composite createPromptingTab(TabFolder tabFolder) {
        Composite composite = SWTUtils.createHFillComposite((Composite)tabFolder, (int)-1, (int)1);
        TabItem tab = new TabItem(tabFolder, 0);
        tab.setText(CVSUIMessages.CVSPreferencesPage_39);
        tab.setControl((Control)composite);
        new StringRadioButtons(composite, "pref_allow_empty_commit_comment", CVSUIMessages.CVSPreferencesPage_40, "org.eclipse.team.cvs.ui.allow_empty_commit_comment", this.YES_NO_PROMPT, new String[]{"always", "never", "prompt"});
        new IntegerRadioButtons(composite, "pref_save_dirty_editors", CVSUIMessages.CVSPreferencesPage_41, "org.eclipse.team.cvs.ui.save_dirty_editors_pref", this.YES_NO_PROMPT, new Integer[]{new Integer(3), new Integer(1), new Integer(2)});
        new StringRadioButtons(composite, "pref_include_change_sets", CVSUIMessages.CVSPreferencesPage_46, "org.eclipse.team.cvs.ui.include_change_sets", this.YES_NO_PROMPT, new String[]{"always", "never", "prompt"});
        new StringRadioButtons(composite, "pref_commit_with_warning", CVSUIMessages.CVSPreferencesPage_50, "org.eclipse.team.cvs.ui.include_change_sets", this.YES_NO_PROMPT, new String[]{"always", "never", "prompt"});
        new StringRadioButtons(composite, "pref_commit_with_errors", CVSUIMessages.CVSPreferencesPage_51, "org.eclipse.team.cvs.ui.include_change_sets", this.YES_NO_PROMPT, new String[]{"always", "never", "prompt"});
        SWTUtils.createPlaceholder((Composite)composite, (int)1);
        return composite;
    }

    private void initializeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        Iterator iter = this.fFields.iterator();
        while (iter.hasNext()) {
            ((Field)iter.next()).initializeValue(store);
        }
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        Iterator iter = this.fFields.iterator();
        while (iter.hasNext()) {
            ((Field)iter.next()).performOk(store);
        }
        CVSProviderPlugin.getPlugin().setReplaceUnmanaged(store.getBoolean("pref_replace_unmanaged"));
        CVSProviderPlugin.getPlugin().setPruneEmptyDirectories(store.getBoolean("pref_prune_empty_directories"));
        CVSProviderPlugin.getPlugin().setTimeout(store.getInt("pref_timeout"));
        CVSProviderPlugin.getPlugin().setQuietness(CVSPreferencesPage.getQuietnessOptionFor(store.getInt("pref_quietness")));
        CVSProviderPlugin.getPlugin().setCompressionLevel(store.getInt("pref_compression_level"));
        CVSProviderPlugin.getPlugin().setDebugProtocol(store.getBoolean("pref_debug_protocol"));
        CVSProviderPlugin.getPlugin().setRepositoriesAreBinary(store.getBoolean("pref_repositories_are_binary"));
        Command.KSubstOption oldKSubst = CVSProviderPlugin.getPlugin().getDefaultTextKSubstOption();
        Command.KSubstOption newKSubst = Command.KSubstOption.fromMode((String)store.getString("pref_text_ksubst"));
        CVSProviderPlugin.getPlugin().setDefaultTextKSubstOption(newKSubst);
        CVSProviderPlugin.getPlugin().setUsePlatformLineend(store.getBoolean("pref_lineend"));
        CVSProviderPlugin.getPlugin().setDetermineVersionEnabled(store.getBoolean("pref_determine_server_version"));
        CVSProviderPlugin.getPlugin().setAutoshareOnImport(store.getBoolean("pref_auto_share_on_import"));
        if (!oldKSubst.equals((Object)newKSubst)) {
            CVSUIPlugin.broadcastPropertyChange(new PropertyChangeEvent((Object)this, "org.eclipse.team.cvs.ui.P_DECORATORS_CHANGED", null, null));
        }
        CVSUIPlugin.getPlugin().savePluginPreferences();
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        IPreferenceStore store = this.getPreferenceStore();
        Iterator iter = this.fFields.iterator();
        while (iter.hasNext()) {
            ((Field)iter.next()).performDefaults(store);
        }
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return CVSUIPlugin.getPlugin().getPreferenceStore();
    }

    protected static Command.QuietOption getQuietnessOptionFor(int option) {
        switch (option) {
            case 0: {
                return Command.VERBOSE;
            }
            case 1: {
                return Command.PARTLY_QUIET;
            }
            case 2: {
                return Command.SILENT;
            }
        }
        return null;
    }

    private class Checkbox
    extends Field {
        private final Button fCheckbox;

        public Checkbox(Composite composite, String key, String label, String helpID) {
            super(key);
            this.fCheckbox = new Button(composite, 32);
            this.fCheckbox.setText(label);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fCheckbox, helpID);
        }

        public void initializeValue(IPreferenceStore store) {
            this.fCheckbox.setSelection(store.getBoolean(this.fKey));
        }

        public void performOk(IPreferenceStore store) {
            store.setValue(this.fKey, this.fCheckbox.getSelection());
        }
    }

    private abstract class ComboBox
    extends Field {
        protected final Combo fCombo;
        private final String[] fLabels;
        private final List fValues;

        public ComboBox(Composite composite, String key, String text, String helpID, String[] labels, Object[] values) {
            super(key);
            this.fLabels = labels;
            this.fValues = Arrays.asList(values);
            Label label = SWTUtils.createLabel((Composite)composite, (String)text);
            this.fCombo = new Combo(composite, 8);
            this.fCombo.setLayoutData((Object)SWTUtils.createHFillGridData());
            this.fCombo.setItems(labels);
            if (((GridLayout)composite.getLayout()).numColumns > 1) {
                label.setLayoutData((Object)SWTUtils.createGridData((int)-1, (int)-1, (boolean)false, (boolean)false));
            }
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fCombo, helpID);
        }

        public Combo getCombo() {
            return this.fCombo;
        }

        public void initializeValue(IPreferenceStore store) {
            Object value = this.getValue(store, this.fKey);
            int index = this.fValues.indexOf(value);
            if (index >= 0 && index < this.fLabels.length) {
                this.fCombo.select(index);
            } else {
                this.fCombo.select(0);
            }
        }

        public void performOk(IPreferenceStore store) {
            this.saveValue(store, this.fKey, this.fValues.get(this.fCombo.getSelectionIndex()));
        }

        protected abstract void saveValue(IPreferenceStore var1, String var2, Object var3);

        protected abstract Object getValue(IPreferenceStore var1, String var2);
    }

    private abstract class Field {
        protected final String fKey;

        public Field(String key) {
            CVSPreferencesPage.this.fFields.add(this);
            this.fKey = key;
        }

        public abstract void initializeValue(IPreferenceStore var1);

        public abstract void performOk(IPreferenceStore var1);

        public void performDefaults(IPreferenceStore store) {
            store.setToDefault(this.fKey);
            this.initializeValue(store);
        }
    }

    private class IntegerComboBox
    extends ComboBox {
        public IntegerComboBox(Composite composite, String key, String label, String helpID, String[] labels, Integer[] values) {
            super(composite, key, label, helpID, labels, values);
        }

        protected void saveValue(IPreferenceStore store, String key, Object object) {
            store.setValue(key, ((Integer)object).intValue());
        }

        protected Object getValue(IPreferenceStore store, String key) {
            return new Integer(store.getInt(key));
        }
    }

    private class IntegerRadioButtons
    extends RadioButtons {
        public IntegerRadioButtons(Composite composite, String key, String label, String helpID, String[] labels, Integer[] values) {
            super(composite, key, label, helpID, labels, values);
        }

        protected Object loadValue(IPreferenceStore store, String key) {
            return new Integer(store.getInt(key));
        }

        protected void saveValue(IPreferenceStore store, String key, Object value) {
            store.setValue(key, ((Integer)value).intValue());
        }
    }

    public static class PerspectiveDescriptorComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            if (o1 instanceof IPerspectiveDescriptor && o2 instanceof IPerspectiveDescriptor) {
                String id1 = ((IPerspectiveDescriptor)o1).getLabel();
                String id2 = ((IPerspectiveDescriptor)o2).getLabel();
                return Collator.getInstance().compare(id1, id2);
            }
            return 0;
        }
    }

    private abstract class RadioButtons
    extends Field {
        protected final Button[] fButtons;
        private final String[] fLabels;
        private final List fValues;
        private final Group fGroup;

        public RadioButtons(Composite composite, String key, String label, String helpID, String[] labels, Object[] values) {
            super(key);
            this.fLabels = labels;
            this.fValues = Arrays.asList(values);
            this.fGroup = SWTUtils.createHFillGroup((Composite)composite, (String)label, (int)-1, (int)labels.length);
            this.fButtons = new Button[labels.length];
            int i = 0;
            while (i < this.fLabels.length) {
                this.fButtons[i] = new Button((Composite)this.fGroup, 16);
                this.fButtons[i].setLayoutData((Object)SWTUtils.createGridData((int)-1, (int)-1, (boolean)false, (boolean)false));
                this.fButtons[i].setText(labels[i]);
                ++i;
            }
            SWTUtils.equalizeControls((PixelConverter)SWTUtils.createDialogPixelConverter((Control)composite), (Control[])this.fButtons, (int)0, (int)(this.fButtons.length - 2));
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fGroup, helpID);
        }

        public void initializeValue(IPreferenceStore store) {
            Object value = this.loadValue(store, this.fKey);
            int index = this.fValues.indexOf(value);
            int i = 0;
            while (i < this.fButtons.length) {
                Button b = this.fButtons[i];
                b.setSelection(index == i);
                ++i;
            }
        }

        public void performOk(IPreferenceStore store) {
            int i = 0;
            while (i < this.fButtons.length) {
                if (this.fButtons[i].getSelection()) {
                    this.saveValue(store, this.fKey, this.fValues.get(i));
                    return;
                }
                ++i;
            }
        }

        public Control getControl() {
            return this.fGroup;
        }

        protected abstract Object loadValue(IPreferenceStore var1, String var2);

        protected abstract void saveValue(IPreferenceStore var1, String var2, Object var3);
    }

    private class StringComboBox
    extends ComboBox {
        public StringComboBox(Composite composite, String key, String label, String helpID, String[] labels, String[] values) {
            super(composite, key, label, helpID, labels, values);
        }

        protected Object getValue(IPreferenceStore store, String key) {
            return store.getString(key);
        }

        protected void saveValue(IPreferenceStore store, String key, Object object) {
            store.setValue(key, (String)object);
        }
    }

    private class StringRadioButtons
    extends RadioButtons {
        public StringRadioButtons(Composite composite, String key, String label, String helpID, String[] labels, String[] values) {
            super(composite, key, label, helpID, labels, values);
        }

        protected Object loadValue(IPreferenceStore store, String key) {
            return store.getString(key);
        }

        protected void saveValue(IPreferenceStore store, String key, Object value) {
            store.setValue(key, (String)value);
        }
    }

    private abstract class TextField
    extends Field
    implements ModifyListener {
        protected final Text fText;

        public TextField(Composite composite, String key, String text, String helpID) {
            super(key);
            Label label = new Label(composite, 64);
            label.setText(text);
            label.setLayoutData((Object)SWTUtils.createGridData((int)-1, (int)-1, (boolean)false, (boolean)false));
            this.fText = SWTUtils.createText((Composite)composite);
            this.fText.addModifyListener((ModifyListener)this);
            if (helpID != null) {
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fText, helpID);
            }
        }

        public Text getControl() {
            return this.fText;
        }

        public void initializeValue(IPreferenceStore store) {
            String value = store.getString(this.fKey);
            this.fText.setText(value);
        }

        public void performOk(IPreferenceStore store) {
            store.setValue(this.fKey, this.fText.getText());
        }

        public void modifyText(ModifyEvent e) {
            this.modifyText(this.fText);
        }

        protected abstract void modifyText(Text var1);
    }
}

