/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.statushandlers;

import com.ibm.icu.text.DateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.progress.ProgressManagerUtil;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.internal.statushandlers.StatusDialog;
import org.eclipse.ui.progress.IProgressConstants;
import org.eclipse.ui.statushandlers.StatusAdapter;

public class StatusNotificationManager {
    private Collection errors = Collections.synchronizedSet(new HashSet());
    private StatusDialog dialog;
    private static StatusNotificationManager sharedInstance;
    private DisposeListener disposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            StatusNotificationManager.this.dialog = null;
            StatusNotificationManager.this.errors.clear();
        }
    };
    static /* synthetic */ Class class$0;

    public static StatusNotificationManager getInstance() {
        if (sharedInstance == null) {
            sharedInstance = new StatusNotificationManager();
        }
        return sharedInstance;
    }

    private StatusNotificationManager() {
    }

    public void addError(StatusAdapter statusAdapter, final boolean modal) {
        if (ErrorDialog.AUTOMATED_MODE) {
            return;
        }
        final StatusInfo statusInfo = new StatusInfo(statusAdapter);
        if (!PlatformUI.isWorkbenchRunning()) {
            WorkbenchPlugin.log(statusInfo.getStatus().getStatus());
            return;
        }
        if (this.dialog == null || this.dialog.getShell().isDisposed()) {
            this.errors.add(statusInfo);
            Object noPromptProperty = statusInfo.getStatus().getProperty(IProgressConstants.NO_IMMEDIATE_ERROR_PROMPT_PROPERTY);
            boolean prompt = true;
            if (noPromptProperty instanceof Boolean) {
                boolean bl = prompt = (Boolean)noPromptProperty == false;
            }
            if (prompt && !PlatformUI.getWorkbench().isClosing()) {
                try {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            if (PlatformUI.getWorkbench().isClosing()) {
                                return;
                            }
                            if (StatusNotificationManager.this.dialog == null) {
                                StatusNotificationManager.this.dialog = new StatusDialog(ProgressManagerUtil.getDefaultParent(), statusInfo, 7, modal);
                                StatusNotificationManager.this.dialog.open();
                                StatusNotificationManager.this.dialog.getShell().addDisposeListener(StatusNotificationManager.this.disposeListener);
                            }
                        }
                    });
                }
                catch (SWTException sWTException) {}
            }
        } else {
            if (statusInfo.getStatus().getProperty(IProgressConstants.NO_IMMEDIATE_ERROR_PROMPT_PROPERTY) != null) {
                statusInfo.getStatus().setProperty(IProgressConstants.NO_IMMEDIATE_ERROR_PROMPT_PROPERTY, Boolean.FALSE);
            }
            if (!PlatformUI.getWorkbench().isClosing()) {
                try {
                    PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                        public void run() {
                            if (PlatformUI.getWorkbench().isClosing()) {
                                return;
                            }
                            StatusNotificationManager.this.openStatusDialog(modal, statusInfo);
                        }
                    });
                }
                catch (SWTException sWTException) {}
            }
        }
    }

    Collection getErrors() {
        return this.errors;
    }

    void openStatusDialog(boolean modal, StatusInfo statusInfo) {
        this.errors.add(statusInfo);
        if (modal && !this.dialog.isModal()) {
            this.dialog.getShell().removeDisposeListener(this.disposeListener);
            this.dialog.close();
            this.dialog = new StatusDialog(ProgressManagerUtil.getDefaultParent(), statusInfo, 7, modal);
            this.dialog.open();
            this.dialog.getShell().addDisposeListener(this.disposeListener);
        } else {
            this.dialog.refresh();
        }
    }

    protected static class StatusInfo
    implements Comparable {
        private final StatusAdapter statusAdapter;

        public boolean equals(Object obj) {
            if (obj instanceof StatusInfo) {
                return this.statusAdapter.equals(((StatusInfo)obj).getStatus());
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return this.statusAdapter.hashCode();
        }

        public StatusInfo(StatusAdapter statusAdapter) {
            this.statusAdapter = statusAdapter;
            Object timestampProperty = statusAdapter.getProperty(StatusAdapter.TIMESTAMP_PROPERTY);
            if (timestampProperty == null || !(timestampProperty instanceof Long)) {
                statusAdapter.setProperty(StatusAdapter.TIMESTAMP_PROPERTY, new Long(System.currentTimeMillis()));
            }
        }

        String getDisplayString() {
            Job job;
            String text = this.statusAdapter.getStatus().getMessage();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.runtime.jobs.Job");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((job = (Job)this.statusAdapter.getAdapter(clazz)) != null) {
                text = job.getName();
            }
            return NLS.bind((String)ProgressMessages.JobInfo_Error, (Object[])new Object[]{text, DateFormat.getDateTimeInstance((int)1, (int)1).format(new Date(this.getTimestamp()))});
        }

        public long getTimestamp() {
            return (Long)this.statusAdapter.getProperty(StatusAdapter.TIMESTAMP_PROPERTY);
        }

        public int compareTo(Object arg0) {
            if (arg0 instanceof StatusInfo) {
                long otherTimestamp = ((StatusInfo)arg0).getTimestamp();
                if (this.getTimestamp() < otherTimestamp) {
                    return -1;
                }
                if (this.getTimestamp() > otherTimestamp) {
                    return 1;
                }
                return this.getDisplayString().compareTo(((StatusInfo)arg0).getDisplayString());
            }
            return 0;
        }

        public StatusAdapter getStatus() {
            return this.statusAdapter;
        }
    }
}

