/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest;

import java.util.Arrays;
import java.util.Iterator;
import org.hamcrest.Description;
import org.hamcrest.SelfDescribing;
import org.hamcrest.internal.ArrayIterator;
import org.hamcrest.internal.SelfDescribingValueIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringDescription
implements Description {
    private final StringBuffer buffer;

    public StringDescription() {
        this(new StringBuffer());
    }

    public StringDescription(StringBuffer buffer) {
        this.buffer = buffer;
    }

    public static String toString(SelfDescribing selfDescribing) {
        StringDescription description = new StringDescription();
        selfDescribing.describeTo(description);
        return description.toString();
    }

    @Override
    public Description appendText(String text) {
        this.buffer.append(text);
        return this;
    }

    @Override
    public Description appendValue(Object value) {
        if (value == null) {
            this.buffer.append("null");
        } else if (value instanceof String) {
            this.toJavaSyntax(this.buffer, (String)value);
        } else if (value instanceof Character) {
            this.buffer.append('\"');
            this.toJavaSyntax(this.buffer, ((Character)value).charValue());
            this.buffer.append('\"');
        } else if (value instanceof Short) {
            this.buffer.append('<').append(value).append("s>");
        } else if (value instanceof Long) {
            this.buffer.append('<').append(value).append("L>");
        } else if (value instanceof Float) {
            this.buffer.append('<').append(value).append("F>");
        } else if (value.getClass().isArray()) {
            this.appendValueList("[", ", ", "]", new ArrayIterator(value));
        } else {
            this.buffer.append('<').append(value).append('>');
        }
        return this;
    }

    @Override
    public <T> Description appendValueList(String start, String separator, String end, T ... values) {
        return this.appendValueList(start, separator, end, (Iterable<T>)Arrays.asList(values));
    }

    @Override
    public <T> Description appendValueList(String start, String separator, String end, Iterable<T> values) {
        return this.appendValueList(start, separator, end, values.iterator());
    }

    private <T> Description appendValueList(String start, String separator, String end, Iterator<T> values) {
        return this.appendList(start, separator, end, new SelfDescribingValueIterator<T>(values));
    }

    @Override
    public Description appendList(String start, String separator, String end, Iterable<? extends SelfDescribing> values) {
        return this.appendList(start, separator, end, values.iterator());
    }

    private Description appendList(String start, String separator, String end, Iterator<? extends SelfDescribing> i) {
        boolean separate = false;
        this.buffer.append(start);
        while (i.hasNext()) {
            if (separate) {
                this.buffer.append(separator);
            }
            i.next().describeTo(this);
            separate = true;
        }
        this.buffer.append(end);
        return this;
    }

    private void toJavaSyntax(StringBuffer buffer, String unformatted) {
        buffer.append('\"');
        for (int i = 0; i < unformatted.length(); ++i) {
            this.toJavaSyntax(buffer, unformatted.charAt(i));
        }
        buffer.append('\"');
    }

    private void toJavaSyntax(StringBuffer buffer, char ch) {
        switch (ch) {
            case '\"': {
                buffer.append("\\\"");
                break;
            }
            case '\n': {
                buffer.append("\\n");
                break;
            }
            case '\r': {
                buffer.append("\\r");
                break;
            }
            case '\t': {
                buffer.append("\\t");
                break;
            }
            default: {
                buffer.append(ch);
            }
        }
    }

    public String toString() {
        return this.buffer.toString();
    }
}

