/*
 * Decompiled with CFR 0.152.
 */
package jdave.tools;

import jdave.Specification;
import jdave.tools.FileStore;
import jdave.tools.IDoxFormat;
import jdave.tools.PlainTextFormat;
import jdave.tools.Specdox;
import jdave.tools.XmlFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpecdoxRunner {
    public static final String FORMAT = "jdave.tools.specdox.format";
    public static final String DIRNAME = "jdave.tools.specdox.dir";

    public void generate(Class<? extends Specification<?>> specType) {
        if (System.getProperty(FORMAT) != null) {
            IDoxFormat format = this.formatFor(System.getProperty(FORMAT));
            Specdox specdox = new Specdox(new FileStore(this.dirname()));
            specdox.generate(specType, format);
        }
    }

    private String dirname() {
        return System.getProperty(DIRNAME, "target/jdave");
    }

    protected IDoxFormat formatFor(String formatName) {
        if (formatName.equals("txt")) {
            return new PlainTextFormat();
        }
        if (formatName.equals("xml")) {
            return new XmlFormat();
        }
        throw new RuntimeException("unknown format '" + formatName + "'");
    }
}

