/*
 * Decompiled with CFR 0.152.
 */
package jdave.util;

public class Diff {
    private static final int CHOP_AT = 15;
    private final String actual;
    private final String expected;

    public Diff(String actual, String expected) {
        this.actual = actual;
        this.expected = expected;
    }

    public String verbose() {
        int diffIndex = this.diffIndex();
        if (diffIndex == -1) {
            throw new IllegalArgumentException("the strings equal");
        }
        int diffStart = Math.max(0, diffIndex - 15);
        String ellipsisStart = diffIndex > 15 ? "..." : "";
        int diffEndActual = Math.min(this.actual.length(), diffIndex + 15);
        String ellipsisEndActual = this.actual.length() > diffIndex + 15 ? "..." : "";
        int diffEndExpected = Math.min(this.expected.length(), diffIndex + 15);
        String ellipsisEndExpected = this.expected.length() > diffIndex + 15 ? "..." : "";
        StringBuilder message = new StringBuilder();
        message.append("  Actual: ");
        message.append(ellipsisStart + this.actual.substring(diffStart, diffEndActual) + ellipsisEndActual);
        message.append(System.getProperty("line.separator"));
        message.append("Expected: ");
        message.append(ellipsisStart + this.expected.substring(diffStart, diffEndExpected) + ellipsisEndExpected);
        return message.toString();
    }

    private int diffIndex() {
        if (this.actual.length() == 0 || this.expected.length() == 0) {
            return 0;
        }
        for (int i = 0; i < this.actual.length() && i < this.expected.length(); ++i) {
            if (this.actual.charAt(i) == this.expected.charAt(i)) continue;
            return i;
        }
        return -1;
    }

    public static Diff diff(String actual, String expected) {
        return new Diff(actual, expected);
    }
}

