/*
 * Decompiled with CFR 0.152.
 */
package jdave.runner;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import jdave.Specification;
import jdave.runner.Behavior;
import jdave.runner.ISpecVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Context {
    public static final String INITIALIZER_NAME = "create";
    static final String DISPOSER_NAME = "destroy";
    private final Class<? extends Specification<?>> specType;
    private final Class<?> contextType;

    public Context(Class<? extends Specification<?>> specType, Class<?> contextType) {
        this.specType = specType;
        this.contextType = contextType;
    }

    public String getName() {
        return this.contextType.getSimpleName();
    }

    protected abstract Behavior newBehavior(Method var1, Class<? extends Specification<?>> var2, Class<?> var3);

    void run(ISpecVisitor callback) {
        for (Method method : this.contextType.getMethods()) {
            if (!this.isBehavior(method)) continue;
            callback.onBehavior(this.newBehavior(method, this.specType, this.contextType));
        }
    }

    private boolean isBehavior(Method method) {
        if (method.getDeclaringClass().equals(Object.class)) {
            return false;
        }
        if (method.getName().equals(INITIALIZER_NAME)) {
            return false;
        }
        if (method.getName().equals(DISPOSER_NAME)) {
            return false;
        }
        return !method.isSynthetic();
    }

    public boolean isContextClass() {
        if (!this.isConcreteAndPublic()) {
            return false;
        }
        if (!this.hasBehaviors()) {
            return false;
        }
        return this.isInnerClass();
    }

    private boolean hasBehaviors() {
        for (Method method : this.contextType.getMethods()) {
            if (!this.isBehavior(method)) continue;
            return true;
        }
        return false;
    }

    private boolean isConcreteAndPublic() {
        int mod = this.contextType.getModifiers();
        return Modifier.isPublic(mod) && !Modifier.isAbstract(mod);
    }

    private boolean isInnerClass() {
        try {
            this.contextType.getDeclaredConstructor(this.specType);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

