/*
 * Decompiled with CFR 0.152.
 */
package jdave.injection;

import java.util.ArrayList;
import java.util.List;
import jdave.injection.Field;
import jdave.injection.IFieldInjector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectionSupport {
    private final int modifiers;

    public InjectionSupport() {
        this.modifiers = 7;
    }

    public InjectionSupport(int modifiers) {
        this.modifiers = modifiers;
    }

    public void inject(Object object, IFieldInjector injector) {
        Class<?> type = object.getClass();
        do {
            List<Field> fields = this.fieldsFor(object, type);
            for (Field field : fields) {
                injector.inject(field);
            }
        } while ((type = type.getSuperclass()) != null);
    }

    private List<Field> fieldsFor(Object object, Class<?> type) {
        java.lang.reflect.Field[] declaredFields;
        ArrayList<Field> fields = new ArrayList<Field>();
        java.lang.reflect.Field[] fieldArray = declaredFields = type.getDeclaredFields();
        int n = declaredFields.length;
        int n2 = 0;
        while (n2 < n) {
            java.lang.reflect.Field field = fieldArray[n2];
            if ((field.getModifiers() & this.modifiers) != 0) {
                fields.add(new Field(object, field));
            }
            ++n2;
        }
        return fields;
    }
}

