/*
 * Decompiled with CFR 0.152.
 */
package jdave.runner;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import jdave.ExpectationFailedException;
import jdave.Specification;
import jdave.runner.Behavior;
import jdave.runner.IBehaviorResults;
import jdave.util.Fields;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutingBehavior
extends Behavior {
    private final Class<?> contextType;
    private final Class<? extends Specification<?>> specType;
    private Object context;

    public ExecutingBehavior(Method method, Class<? extends Specification<?>> specType, Class<?> contextType) {
        super(method);
        this.specType = specType;
        this.contextType = contextType;
    }

    @Override
    public void run(IBehaviorResults results) {
        try {
            Specification<?> spec = this.newSpecification();
            if (spec.needsThreadLocalIsolation()) {
                this.runInNewThread(results, spec);
            } else {
                this.runInCurrentThread(results, spec);
            }
        }
        catch (RuntimeException e) {
            results.error(this.method, e);
        }
    }

    private void runInCurrentThread(IBehaviorResults results, Specification<?> spec) {
        this.runSpec(results, spec);
    }

    private void runInNewThread(final IBehaviorResults results, final Specification<?> spec) {
        ExecutorService executor = Executors.newSingleThreadExecutor(new ThreadFactory(){

            public Thread newThread(Runnable r) {
                return new Thread(r);
            }
        });
        executor.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ExecutingBehavior.this.runSpec(results, spec);
                return null;
            }
        });
        executor.shutdown();
        try {
            executor.awaitTermination(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * Loose catch block
     */
    private void runSpec(IBehaviorResults results, Specification<?> spec) {
        block11: {
            try {
                try {
                    spec.create();
                    this.context = this.newContext(spec);
                    this.method.invoke(this.context, new Object[0]);
                    spec.verifyMocks();
                    results.expected(this.method);
                }
                catch (InvocationTargetException e) {
                    if (e.getCause().getClass().equals(ExpectationFailedException.class)) {
                        results.unexpected(this.method, (ExpectationFailedException)e.getCause());
                    } else {
                        results.error(this.method, e.getCause());
                    }
                    this.destroyContext();
                    spec.fireAfterContextDestroy(this.context);
                    spec.destroy();
                }
                catch (ExpectationFailedException e) {
                    results.unexpected(this.method, e);
                    this.destroyContext();
                    spec.fireAfterContextDestroy(this.context);
                    spec.destroy();
                }
                catch (Throwable t) {
                    results.error(this.method, t);
                    this.destroyContext();
                    spec.fireAfterContextDestroy(this.context);
                    spec.destroy();
                    break block11;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
            }
            finally {
                this.destroyContext();
                spec.fireAfterContextDestroy(this.context);
                spec.destroy();
            }
        }
    }

    protected Specification<?> newSpecification() {
        try {
            return this.specType.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Object newContext(Specification<?> spec) throws Exception {
        Object context = this.newContextInstance(spec);
        spec.fireAfterContextInstantiation(context);
        Object contextObject = spec.getContextObjectFactory().newContextObject(context);
        Fields.set(spec, "be", contextObject);
        Fields.set(spec, "context", contextObject);
        spec.fireAfterContextCreation(context, contextObject);
        return context;
    }

    protected void destroyContext() {
        if (this.context != null) {
            this.invokeDisposer(this.context);
        }
    }

    private Object newContextInstance(Specification<?> spec) {
        try {
            Constructor<?> constructor = this.contextType.getDeclaredConstructor(spec.getClass());
            return constructor.newInstance(spec);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void invokeDisposer(Object context) {
        try {
            Method method = context.getClass().getMethod("destroy", new Class[0]);
            method.invoke(context, new Object[0]);
        }
        catch (Exception e) {
            return;
        }
    }
}

